/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.sanitization.MessageTransformer;
import de.tum.in.test.api.internal.sanitization.SanitizationUtils;
import de.tum.in.test.api.internal.sanitization.SpecificThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.ThrowableInfo;
import de.tum.in.test.api.internal.sanitization.ThrowableSanitizer;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.assertj.core.error.MultipleAssertionsError;

enum MultipleAssertionsErrorSanitizer implements SpecificThrowableSanitizer
{
    INSTANCE;

    private final Set<Class<? extends Throwable>> types = Set.of(MultipleAssertionsError.class);

    @Override
    public boolean canSanitize(Throwable t) {
        return this.types.contains(t.getClass());
    }

    @Override
    public Throwable sanitize(Throwable t, MessageTransformer messageTransformer) {
        MultipleAssertionsError mae = (MultipleAssertionsError)t;
        ThrowableInfo info = ThrowableInfo.getEssentialInfosSafeFrom((Throwable)mae).sanitize();
        List errors = BlacklistedInvoker.invoke(() -> List.copyOf(mae.getErrors())).stream().map(ThrowableSanitizer::sanitize).map(AssertionError.class::cast).collect(Collectors.toUnmodifiableList());
        String description = "";
        if (info.getMessage().startsWith("[")) {
            String messageWithoutDecscription = BlacklistedInvoker.invoke(() -> new MultipleAssertionsError(mae.getErrors()).getMessage());
            String start = SanitizationUtils.removeSuffixMatching(info.getMessage(), messageWithoutDecscription);
            if (start != null) {
                description = start.substring(1, start.length() - 2);
            }
        }
        info.setMessage(description);
        description = messageTransformer.apply(info);
        MultipleAssertionsError newMae = new MultipleAssertionsError((Description)new TextDescription(description, new Object[0]), errors);
        SanitizationUtils.copyThrowableInfoSafe(info, (Throwable)newMae);
        return newMae;
    }
}

