/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.sanitization.SanitizationAction;
import de.tum.in.test.api.internal.sanitization.SanitizationException;
import de.tum.in.test.api.internal.sanitization.ThrowableInfo;

final class SanitizationUtils {
    private SanitizationUtils() {
    }

    static void copyThrowableInfoSafe(Throwable from, Throwable to) {
        SanitizationUtils.copyThrowableInfoSafe(ThrowableInfo.getEssentialInfosSafeFrom(from), to);
    }

    static void copyThrowableInfoSafe(ThrowableInfo from, Throwable to) {
        Throwable[] toSuppr;
        Throwable[] fromSuppr;
        StackTraceElement[] fromStackTrace;
        block6: {
            if (!from.isSanitized()) {
                from.sanitize();
            }
            Throwable fromCause = from.getCause();
            fromStackTrace = from.getStackTrace();
            fromSuppr = from.getSuppressed();
            Throwable toCause = BlacklistedInvoker.invoke(to::getCause);
            toSuppr = to.getSuppressed();
            if (toCause == null) {
                try {
                    BlacklistedInvoker.invoke(() -> to.initCause(fromCause));
                }
                catch (IllegalStateException ignored) {
                    if (fromCause == null) break block6;
                    to.addSuppressed(fromCause);
                }
            }
        }
        BlacklistedInvoker.invoke(() -> to.setStackTrace(fromStackTrace));
        if (toSuppr.length == 0 && fromSuppr.length > 0) {
            for (Throwable suppressed : toSuppr) {
                to.addSuppressed(suppressed);
            }
        }
    }

    static <T> T sanitizeWithinScopeOf(Object scope, SanitizationAction<T> sanitizationAction) {
        return SanitizationUtils.sanitizeWithinScopeOf(scope.getClass(), sanitizationAction);
    }

    static <T> T sanitizeWithinScopeOf(Class<?> scope, SanitizationAction<T> sanitizationAction) {
        try {
            return sanitizationAction.executeSanitization();
        }
        catch (SanitizationException sanitizationException) {
            throw sanitizationException;
        }
        catch (Throwable t) {
            throw new SanitizationException(scope, t);
        }
    }

    static String removeSuffixMatching(String s, String suffix) {
        int end = s.lastIndexOf(suffix);
        if (end == -1 || end + suffix.length() < s.length()) {
            return null;
        }
        return s.substring(0, end);
    }
}

