/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.util;

import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.sanitization.ThrowableSanitizer;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED)
public final class UnexpectedExceptionError
extends Error {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Throwable> originalType;

    private UnexpectedExceptionError(Class<? extends Throwable> originalType, String message, Throwable cause, StackTraceElement[] stackTrace, Throwable[] suppressed) {
        super(message, ThrowableSanitizer.sanitize(cause), true, true);
        this.originalType = originalType;
        this.setStackTrace(stackTrace);
        for (Throwable sup : suppressed) {
            this.addSuppressed(ThrowableSanitizer.sanitize(sup));
        }
    }

    public Class<? extends Throwable> getOriginalType() {
        return this.originalType;
    }

    public static UnexpectedExceptionError wrap(Throwable t) {
        if (t == null) {
            return null;
        }
        String message = BlacklistedInvoker.invoke(t::toString);
        Throwable cause = BlacklistedInvoker.invoke(t::getCause);
        Class<?> originalType = t.getClass();
        StackTraceElement[] stackTrace = BlacklistedInvoker.invoke(t::getStackTrace);
        Throwable[] suppressed = BlacklistedInvoker.invoke(t::getSuppressed);
        return new UnexpectedExceptionError(originalType, message, cause, stackTrace, suppressed);
    }

    public static UnexpectedExceptionError create(Class<? extends Throwable> originalType, String message, Throwable cause, StackTraceElement[] stackTrace, Throwable[] suppressed) {
        return new UnexpectedExceptionError(Objects.requireNonNull(originalType), message, cause, Objects.requireNonNull(stackTrace), Objects.requireNonNull(suppressed));
    }
}

