/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.validate;

public final class Validate {
    private Validate() {
        throw new UnsupportedOperationException("Must not be caled via reflection!");
    }

    public static <T> T notNull(T reference, String name) {
        if (null == reference) {
            if (null == name) {
                throw new NullPointerException();
            }
            throw new NullPointerException(String.format("Parameter '%s' must not be null!", name));
        }
        return reference;
    }

    public static <T> T notNull(T reference) {
        return Validate.notNull(reference, null);
    }

    public static String notEmpty(String reference, String name) {
        Validate.notNull(reference, name);
        if (reference.isEmpty()) {
            if (null == name) {
                throw new IllegalArgumentException("Parameter must not be empty!");
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be empty!", name));
        }
        return reference;
    }

    public static String notEmpty(String reference) {
        return Validate.notEmpty(reference, null);
    }

    public static int greaterThan(int reference, int lowerBound, String name) {
        if (reference <= lowerBound) {
            if (null == name) {
                throw new NullPointerException(String.format("Reference is not greater than lower bound: %d > %d!", reference, lowerBound));
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' must be greater than %d (was %d)!", name, lowerBound, reference));
        }
        return reference;
    }

    public static int greaterThan(int reference, int lowerBound) {
        return Validate.greaterThan(reference, lowerBound, null);
    }

    public static int greaterThanOrEqual(int reference, int lowerBound, String name) {
        if (reference < lowerBound) {
            if (null == name) {
                throw new NullPointerException(String.format("Reference is not less than lower bound: %d < %d!", reference, lowerBound));
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' must be greater or equal than %d (was %d)!", name, lowerBound, reference));
        }
        return reference;
    }

    public static int greaterThanOrEqual(int reference, int lowerBound) {
        return Validate.greaterThanOrEqual(reference, lowerBound, null);
    }

    public static long greaterThan(long reference, long lowerBound, String name) {
        if (reference <= lowerBound) {
            if (null == name) {
                throw new NullPointerException(String.format("Reference is not less equal than lower bound: %d <= %d!", reference, lowerBound));
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' must be greater than %d (was %d)!", name, lowerBound, reference));
        }
        return reference;
    }

    public static long greaterThan(long reference, long lowerBound) {
        return Validate.greaterThan(reference, lowerBound, null);
    }

    public static long greaterThanOrEqual(long reference, long lowerBound, String name) {
        if (reference < lowerBound) {
            if (null == name) {
                throw new NullPointerException(String.format("Reference is not less than lower bound: %d < %d!", reference, lowerBound));
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' must be greater than or equal %d (was %d)!", name, lowerBound, reference));
        }
        return reference;
    }

    public static long greaterThanOrEqual(long reference, long lowerBound) {
        return Validate.greaterThanOrEqual(reference, lowerBound, null);
    }

    public static void isTrue(boolean expression, String message) {
        Validate.notEmpty(message, "Parameter 'message' must not be null or empty!");
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static int checkElementIndex(int index, int size) {
        return Validate.checkElementIndex(index, size, "index");
    }

    public static int checkElementIndex(int index, int size, String desc) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(Validate.badElementIndex(index, size, desc));
        }
        return index;
    }

    private static String badElementIndex(int index, int size, String desc) {
        if (index < 0) {
            return Validate.format("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Validate.format("%s (%s) must be less than size (%s)", desc, index, size);
    }

    static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            throw new IndexOutOfBoundsException(Validate.badPositionIndexes(start, end, size));
        }
    }

    private static String badPositionIndexes(int start, int end, int size) {
        if (start < 0 || start > size) {
            return Validate.badPositionIndex(start, size, "start index");
        }
        if (end < 0 || end > size) {
            return Validate.badPositionIndex(end, size, "end index");
        }
        return Validate.format("end index (%s) must not be less than start index (%s)", end, start);
    }

    private static String badPositionIndex(int index, int size, String desc) {
        if (index < 0) {
            return Validate.format("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Validate.format("%s (%s) must not be greater than size (%s)", desc, index, size);
    }
}

