/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osm_legal_default_speeds.tagfilter;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007\u001a\u0013\u0010\b\u001a\u0004\u0018\u00010\u0004*\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"feetInchRegex", "Lkotlin/text/Regex;", "withUnitRegex", "toStandardUnitsFactor", "", "unit", "", "(Ljava/lang/String;)Ljava/lang/Double;", "withOptionalUnitToDoubleOrNull", "library"})
public final class NumberWithUnitParserKt {
    @NotNull
    private static final Regex feetInchRegex = new Regex("([0-9]+)\\s*(?:'|ft)\\s*([0-9]+)\\s*(?:\"|in)");
    @NotNull
    private static final Regex withUnitRegex = new Regex("([0-9]+|[0-9]*\\.[0-9]+)\\s*([a-z/'\"]+)");

    @Nullable
    public static final Double withOptionalUnitToDoubleOrNull(@NotNull String $this$withOptionalUnitToDoubleOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$withOptionalUnitToDoubleOrNull, (String)"<this>");
        if (((CharSequence)$this$withOptionalUnitToDoubleOrNull).length() == 0) {
            return null;
        }
        if (!Character.isDigit(StringsKt.first((CharSequence)$this$withOptionalUnitToDoubleOrNull)) && StringsKt.first((CharSequence)$this$withOptionalUnitToDoubleOrNull) != '.') {
            return null;
        }
        if (!Character.isLetter(StringsKt.last((CharSequence)$this$withOptionalUnitToDoubleOrNull)) && StringsKt.last((CharSequence)$this$withOptionalUnitToDoubleOrNull) != '\"' && StringsKt.last((CharSequence)$this$withOptionalUnitToDoubleOrNull) != '\'') {
            return StringsKt.toDoubleOrNull((String)$this$withOptionalUnitToDoubleOrNull);
        }
        MatchResult withUnitResult = withUnitRegex.matchEntire((CharSequence)$this$withOptionalUnitToDoubleOrNull);
        if (withUnitResult != null) {
            MatchResult.Destructured destructured = withUnitResult.getDestructured();
            String value = (String)destructured.getMatch().getGroupValues().get(1);
            String unit = (String)destructured.getMatch().getGroupValues().get(2);
            Double d = StringsKt.toDoubleOrNull((String)value);
            if (d == null) {
                return null;
            }
            double v = d;
            Double d2 = NumberWithUnitParserKt.toStandardUnitsFactor(unit);
            if (d2 == null) {
                return null;
            }
            double factor = d2;
            return v * factor;
        }
        MatchResult feetInchResult = feetInchRegex.matchEntire((CharSequence)$this$withOptionalUnitToDoubleOrNull);
        if (feetInchResult != null) {
            MatchResult.Destructured destructured = feetInchResult.getDestructured();
            String feet = (String)destructured.getMatch().getGroupValues().get(1);
            String inches = (String)destructured.getMatch().getGroupValues().get(2);
            double d = Integer.parseInt(feet);
            Double d3 = NumberWithUnitParserKt.toStandardUnitsFactor("ft");
            Intrinsics.checkNotNull((Object)d3);
            double d4 = d * d3;
            double d5 = Integer.parseInt(inches);
            Double d6 = NumberWithUnitParserKt.toStandardUnitsFactor("in");
            Intrinsics.checkNotNull((Object)d6);
            return d4 + d5 * d6;
        }
        return null;
    }

    private static final Double toStandardUnitsFactor(String unit) {
        Double d;
        switch (unit) {
            case "kph": 
            case "km/h": {
                d = 1.0;
                break;
            }
            case "mph": {
                d = 1.609344;
                break;
            }
            case "m": {
                d = 1.0;
                break;
            }
            case "mm": {
                d = 0.001;
                break;
            }
            case "cm": {
                d = 0.01;
                break;
            }
            case "km": {
                d = 1000.0;
                break;
            }
            case "'": 
            case "ft": {
                d = 0.3048;
                break;
            }
            case "\"": 
            case "in": {
                d = 0.0254;
                break;
            }
            case "yds": 
            case "yd": {
                d = 0.9144;
                break;
            }
            case "t": {
                d = 1.0;
                break;
            }
            case "kg": {
                d = 0.001;
                break;
            }
            case "st": {
                d = 0.90718474;
                break;
            }
            case "lt": {
                d = 1.0160469;
                break;
            }
            case "lb": 
            case "lbs": {
                d = 4.5359237E-4;
                break;
            }
            case "cwt": {
                d = 0.05080234544;
                break;
            }
            default: {
                d = null;
            }
        }
        return d;
    }
}

