/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.metadata.nbmdr;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import org.apache.tools.ant.types.FileSet;
import org.dentaku.services.metadata.RepositoryException;
import org.dentaku.services.metadata.RepositoryReader;
import org.dentaku.services.metadata.Utils;
import org.dentaku.services.metadata.nbmdr.XMIInputConfigImpl;
import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.xmi.XMIInputConfig;
import org.netbeans.api.xmi.XMIReader;
import org.netbeans.api.xmi.XMIReaderFactory;
import org.omg.uml.UmlPackage;
import org.omg.uml.modelmanagement.Model;

public class MagicDrawRepositoryReader
implements RepositoryReader {
    private String model = null;
    private URL modelURL;
    private List searchPaths = new ArrayList();
    private Logger log = Logger.getLogger((class$org$dentaku$services$metadata$nbmdr$MagicDrawRepositoryReader == null ? (class$org$dentaku$services$metadata$nbmdr$MagicDrawRepositoryReader = MagicDrawRepositoryReader.class$("org.dentaku.services.metadata.nbmdr.MagicDrawRepositoryReader")) : class$org$dentaku$services$metadata$nbmdr$MagicDrawRepositoryReader).getName());
    protected static final String META_PACKAGE = "UML";
    public static final String MODEL_NAME = "MODEL";
    private UmlPackage modelPackage = null;
    static /* synthetic */ Class class$org$dentaku$services$metadata$nbmdr$MagicDrawRepositoryReader;

    public MagicDrawRepositoryReader() {
    }

    public MagicDrawRepositoryReader(URL modelURL) {
        this.modelURL = modelURL;
    }

    public MagicDrawRepositoryReader(URL modelURL, Collection fileSet) {
        this.modelURL = modelURL;
        Iterator it = fileSet.iterator();
        while (it.hasNext()) {
            FileSet set = (FileSet)it.next();
            this.searchPaths.add(set.getDir(null).getAbsolutePath());
        }
    }

    public UmlPackage getModel() throws RepositoryException {
        if (this.modelPackage == null) {
            this.log.info("creating repository");
            MDRepository repository = MDRManager.getDefault().getDefaultRepository();
            try {
                MofPackage metaModelPackage;
                URL metamodel = this.getClass().getResource("/M2_DiagramInterchangeModel.xml");
                ModelPackage metaModelExtent = (ModelPackage)repository.getExtent(metamodel.toExternalForm());
                if (metaModelExtent == null) {
                    metaModelExtent = (ModelPackage)repository.createExtent(metamodel.toExternalForm());
                }
                if ((metaModelPackage = this.findPackage(META_PACKAGE, metaModelExtent)) == null) {
                    XMIReader xmiReader = XMIReaderFactory.getDefault().createXMIReader();
                    xmiReader.read(metamodel.toExternalForm(), (RefPackage)metaModelExtent);
                    metaModelPackage = this.findPackage(META_PACKAGE, metaModelExtent);
                }
                MofPackage metaModel = metaModelPackage;
                RefPackage model1 = repository.getExtent(MODEL_NAME);
                if (model1 != null) {
                    this.log.info("MDR: deleting exising model");
                    model1.refDelete();
                }
                model1 = repository.createExtent(MODEL_NAME, (RefObject)metaModel);
                this.readInputStream((UmlPackage)model1);
                this.modelPackage = (UmlPackage)model1;
            }
            catch (Exception e) {
                throw new RepositoryException("could not instantiate repostiory", e);
            }
        }
        return this.modelPackage;
    }

    private void readInputStream(UmlPackage umlModel) throws IOException, MalformedXMIException {
        InputStream input;
        if (this.model != null) {
            this.modelURL = Utils.checkURL(this.model);
            if (this.modelURL == null) {
                this.modelURL = Utils.checkURL(Utils.getRootDir() + this.model);
            }
        } else if (this.modelURL != null) {
            try {
                this.modelURL = Utils.checkURL(this.modelURL);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.modelURL == null) {
            this.log.warning("XMI repository could not be found and none loaded!");
            Model m = umlModel.getModelManagement().getModel().createModel();
            m.setName("Data");
            return;
        }
        String fullname = this.modelURL.toExternalForm();
        System.out.println("Reading from MagicDraw repository: " + fullname);
        if (fullname.endsWith(".zip")) {
            String filename = fullname.substring(fullname.lastIndexOf("/") + 1, fullname.indexOf(".zip"));
            input = this.openInputStreamFromZip(this.modelURL, filename);
        } else {
            input = this.modelURL.openStream();
        }
        XMIReader xmiReader = XMIReaderFactory.getDefault().createXMIReader((XMIInputConfig)new XMIInputConfigImpl(new RefPackage[]{umlModel}, this.searchPaths));
        xmiReader.read(input, fullname, (RefPackage)umlModel);
    }

    private InputStream openInputStreamFromZip(URL url, String filename) throws IOException {
        ZipFile zip = new ZipFile(url.getFile());
        ZipEntry entry = zip.getEntry(filename);
        InputStream input = null;
        try {
            input = zip.getInputStream(entry);
        }
        catch (IOException e) {
            this.log.severe("couldn't find file in archive.  Make sure you have not recently renamed the file at the OS level and/or re-save");
            throw e;
        }
        return input;
    }

    private MofPackage findPackage(String packageName, ModelPackage metaModel) {
        Iterator it = metaModel.getMofPackage().refAllOfClass().iterator();
        while (it.hasNext()) {
            ModelElement temp = (ModelElement)it.next();
            if (!temp.getName().equals(packageName)) continue;
            return (MofPackage)temp;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        System.setProperty("org.netbeans.lib.jmi.Logger.fileName", "mdr.log");
        System.setProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName", "org.netbeans.mdr.persistence.memoryimpl.StorageFactoryImpl");
    }
}

