/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.metadata;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.netbeans.jmiimpl.omg.uml.foundation.core.ClassifierImpl;
import org.netbeans.jmiimpl.omg.uml.foundation.core.ModelElementImpl;
import org.netbeans.jmiimpl.omg.uml.modelmanagement.ModelImpl;
import org.omg.uml.UmlPackage;
import org.omg.uml.foundation.core.CorePackage;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.TagDefinition;
import org.omg.uml.foundation.core.TaggedValue;
import org.omg.uml.foundation.core.UmlClass;

public class Utils {
    public static String getRootDir() {
        String rootdir = System.getProperty("dentaku.rootdir");
        if (rootdir == null) {
            rootdir = System.getProperty("user.dir");
        }
        return rootdir + "/";
    }

    public static URL checkURL(URL check) {
        URL result = null;
        if (check != null) {
            try {
                InputStream is = check.openStream();
                is.close();
                result = check;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public static URL checkURL(String check) {
        URL result = null;
        if (check != null) {
            try {
                result = Utils.checkURL(new File(check).toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return result;
    }

    public static ClassifierImpl findUmlClass(UmlPackage umlPackage, String pkgName, final String entityName, boolean create) {
        ModelImpl model = Utils.getModelRoot(umlPackage);
        org.omg.uml.modelmanagement.UmlPackage newPackage = model.getChildPackage(pkgName, create);
        ClassifierImpl result = (ClassifierImpl)CollectionUtils.find((Collection)newPackage.getOwnedElement(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof UmlClass && ((UmlClass)object).getName().equals(entityName);
            }
        });
        if (result == null) {
            CorePackage core = umlPackage.getCore();
            result = (ClassifierImpl)((Object)core.getUmlClass().createUmlClass());
            result.setName(entityName);
            core.getANamespaceOwnedElement().add(newPackage, result);
        }
        return result;
    }

    public static TaggedValue createTaggedValue(CorePackage core, ModelElement owner, TagDefinition tagdefType, String key, String value) {
        TaggedValue taggedValue = core.getTaggedValue().createTaggedValue();
        taggedValue.setName(key);
        taggedValue.getDataValue().add(value);
        if (tagdefType == null) {
            tagdefType = core.getTagDefinition().createTagDefinition();
            tagdefType.setTagType("String");
        }
        taggedValue.setType(tagdefType);
        core.getAModelElementTaggedValue().add(owner, taggedValue);
        return taggedValue;
    }

    public static ModelImpl getModelRoot(UmlPackage model) {
        ModelImpl m = (ModelImpl)CollectionUtils.find((Collection)model.getCore().getNamespace().refAllOfType(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return ((ModelElementImpl)o).getNamespace() == null;
            }
        });
        return m;
    }
}

