/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.metadata;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.dentaku.services.metadata.JMICapableMetadataProvider;
import org.dentaku.services.metadata.RepositoryException;
import org.dentaku.services.metadata.RepositoryReader;
import org.dentaku.services.metadata.Utils;
import org.generama.ConfigurableDocletTagFactory;
import org.netbeans.jmiimpl.omg.uml.foundation.core.ClassifierImpl;
import org.omg.uml.UmlPackage;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Generalization;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.foundation.core.TaggedValue;
import org.omg.uml.foundation.datatypes.ParameterDirectionKindEnum;
import org.omg.uml.foundation.datatypes.VisibilityKind;
import org.omg.uml.foundation.datatypes.VisibilityKindEnum;
import org.omg.uml.modelmanagement.Model;
import org.picocontainer.Startable;
import org.xdoclet.JavaSourceProvider;

public abstract class JMIMetadataProviderBase
implements JMICapableMetadataProvider,
org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable,
Startable {
    protected RepositoryReader reader;
    protected UmlPackage umlPackage;
    protected final ConfigurableDocletTagFactory docletTagFactory = new ConfigurableDocletTagFactory();
    protected JavaSourceProvider fileProvider = null;

    protected JMIMetadataProviderBase() {
    }

    public JMIMetadataProviderBase(RepositoryReader reader) {
        this.reader = reader;
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
    }

    public JMIMetadataProviderBase(RepositoryReader reader, JavaSourceProvider fileProvider) {
        this(reader);
        this.fileProvider = fileProvider;
    }

    public String getOriginalFileName(Object object) {
        if (object == null || !(object instanceof ModelElement)) {
            return "";
        }
        String result = null;
        ModelElement modelElement = (ModelElement)object;
        if (object instanceof TaggedValue) {
            result = ((TaggedValue)object).getName();
            if (result == null && ((TaggedValue)object).getType() != null && (result = ((TaggedValue)object).getType().getName()) == null) {
                result = ((TaggedValue)object).getType().getTagType();
            }
        } else {
            result = modelElement.getName();
        }
        return result + ".java";
    }

    public String getOriginalPackageName(Object object) {
        if (object == null || !(object instanceof ModelElement)) {
            return "";
        }
        ModelElement modelElement = (ModelElement)object;
        String packageName = "";
        Namespace namespace = modelElement.getNamespace();
        while (namespace instanceof org.omg.uml.modelmanagement.UmlPackage && !(namespace instanceof Model)) {
            packageName = "".equals(packageName) ? namespace.getName() : namespace.getName() + "." + packageName;
            namespace = namespace.getNamespace();
        }
        return packageName;
    }

    public UmlPackage getModel() throws RepositoryException {
        return this.umlPackage;
    }

    public ConfigurableDocletTagFactory getDocletTagFactory() {
        return this.docletTagFactory;
    }

    public void start() {
        try {
            this.umlPackage = this.reader.getModel();
        }
        catch (RepositoryException e) {
            throw new RuntimeException("couldn't load JMI metadata", e);
        }
        if (this.fileProvider != null) {
            JavaDocBuilder builder = null;
            try {
                builder = new JavaDocBuilder((DocletTagFactory)this.docletTagFactory);
                builder.setEncoding(this.fileProvider.getEncoding());
                Collection urls = this.fileProvider.getURLs();
                Iterator iterator = urls.iterator();
                while (iterator.hasNext()) {
                    URL next = (URL)iterator.next();
                    builder.addSource(next);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("couldn't load QDox metadata", e);
            }
            this.addClassesToJMI(builder);
        }
    }

    private void addClassesToJMI(JavaDocBuilder builder) {
        JavaClass[] classes = builder.getClasses();
        for (int i = 0; i < classes.length; ++i) {
            JavaClass aClass = classes[i];
            ClassifierImpl cls = this.findClass(aClass);
            this.handleFields(aClass, cls);
            this.handleMethods(aClass, cls);
            cls.setVisibility(this.getVisibility(aClass.getModifiers()));
            ClassifierImpl superclass = this.findClass(aClass.getSuperClass().getJavaClass());
            this.createGeneralization(superclass, cls);
            Type[] interfaces = aClass.getImplements();
            for (int j = 0; j < interfaces.length; ++j) {
                Type anInterface = interfaces[j];
                this.createGeneralization(this.findClass(anInterface.getJavaClass()), cls);
            }
            this.createTags((AbstractJavaEntity)aClass, cls);
        }
    }

    private void createGeneralization(ClassifierImpl superclass, ClassifierImpl cls) {
        Generalization g = this.umlPackage.getCore().getGeneralization().createGeneralization();
        g.setParent(superclass);
        g.setChild(cls);
    }

    private void createTags(AbstractJavaEntity aClass, ModelElement cls) {
        DocletTag[] tags = aClass.getTags();
        for (int j = 0; j < tags.length; ++j) {
            DocletTag tag = tags[j];
            Utils.createTaggedValue(this.umlPackage.getCore(), cls, null, tag.getName(), tag.getValue());
        }
    }

    private void handleMethods(JavaClass aClass, ClassifierImpl cls) {
        JavaMethod[] methods = aClass.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            JavaMethod javaMethod = methods[j];
            Operation o = this.umlPackage.getCore().getOperation().createOperation();
            o.setName(javaMethod.getName());
            o.setVisibility(this.getVisibility(javaMethod.getModifiers()));
            JavaParameter[] params = javaMethod.getParameters();
            for (int k = 0; k < params.length; ++k) {
                JavaParameter param = params[k];
                this.addParameterToOperation(o, param.getName(), param.getType(), ParameterDirectionKindEnum.PDK_IN);
            }
            this.addParameterToOperation(o, null, javaMethod.getReturns(), ParameterDirectionKindEnum.PDK_RETURN);
            this.createTags((AbstractJavaEntity)javaMethod, o);
            cls.getOperations().add(o);
        }
    }

    private void addParameterToOperation(Operation o, String name, Type type, ParameterDirectionKindEnum direction) {
        Parameter p = this.umlPackage.getCore().getParameter().createParameter();
        if (name != null) {
            p.setName(name);
        }
        p.setType(this.findClass(type.getJavaClass()));
        p.setKind(direction);
        o.getParameter().add(p);
    }

    private void handleFields(JavaClass aClass, ClassifierImpl cls) {
        JavaField[] fields = aClass.getFields();
        for (int j = 0; j < fields.length; ++j) {
            JavaField field = fields[j];
            Attribute attribute = this.umlPackage.getCore().getAttribute().createAttribute();
            attribute.setName(field.getName());
            attribute.setVisibility(this.getVisibility(field.getModifiers()));
            JavaClass javaClass = field.getType().getJavaClass();
            attribute.setType(this.findClass(javaClass));
            this.createTags((AbstractJavaEntity)field, attribute);
            cls.getAttributes().add(attribute);
        }
    }

    private ClassifierImpl findClass(JavaClass javaClass) {
        return Utils.findUmlClass(this.umlPackage, javaClass.getPackage(), javaClass.getName(), true);
    }

    private VisibilityKind getVisibility(String[] modifiers) {
        for (int i = 0; i < modifiers.length; ++i) {
            String modifier = modifiers[i];
            if (modifier.equals("public")) {
                return VisibilityKindEnum.VK_PUBLIC;
            }
            if (modifier.equals("protected")) {
                return VisibilityKindEnum.VK_PROTECTED;
            }
            if (!modifier.equals("private")) continue;
            return VisibilityKindEnum.VK_PRIVATE;
        }
        return VisibilityKindEnum.VK_PACKAGE;
    }

    public void stop() {
    }
}

