/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.metadata.nbmdr;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jmi.reflect.RefPackage;
import org.dentaku.services.metadata.Utils;
import org.dentaku.services.metadata.nbmdr.PathElement;
import org.netbeans.api.xmi.XMIInputConfig;
import org.netbeans.api.xmi.XMIReferenceResolver;
import org.netbeans.lib.jmi.xmi.XmiContext;

public class XMIInputConfigImpl
extends XMIInputConfig {
    private Collection paths = new ArrayList();
    private XMIReferenceResolverImpl xmiReferenceResolver;

    public XMIInputConfigImpl(RefPackage[] extents, Collection searchPaths) {
        Iterator it = searchPaths.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof PathElement) {
                this.paths.add(((PathElement)o).getId());
                continue;
            }
            this.paths.add(o);
        }
        this.xmiReferenceResolver = new XMIReferenceResolverImpl(extents, this);
    }

    public void setReferenceResolver(XMIReferenceResolver resolver) {
        throw new UnsupportedOperationException();
    }

    public XMIReferenceResolver getReferenceResolver() {
        return this.xmiReferenceResolver;
    }

    public class XMIReferenceResolverImpl
    extends XmiContext {
        private Map urlCache;

        public XMIReferenceResolverImpl(RefPackage[] extents, XMIInputConfig config) {
            super(extents, config);
            this.urlCache = new HashMap();
        }

        public URL toURL(String systemId) {
            URL result = (URL)this.urlCache.get(systemId);
            if (result == null) {
                String fullname;
                result = Utils.checkURL(systemId);
                if (result == null) {
                    result = Utils.checkURL(((Object)((Object)this)).getClass().getClassLoader().getResource(systemId));
                }
                if (result == null) {
                    XMIInputConfigImpl.this.paths.add(".");
                    String filename = systemId.substring(systemId.lastIndexOf("/") + 1);
                    String rootdir = Utils.getRootDir();
                    Iterator it = XMIInputConfigImpl.this.paths.iterator();
                    while (it.hasNext()) {
                        try {
                            String parent = (String)it.next();
                            result = Utils.checkURL(new File(parent, filename).toURL());
                            if (result == null && (result = Utils.checkURL(new File(rootdir + parent, filename).toURL())) == null) continue;
                            break;
                        }
                        catch (MalformedURLException e) {
                        }
                    }
                }
                if (result != null && (fullname = result.toExternalForm()).endsWith(".zip")) {
                    String filename = fullname.substring(fullname.lastIndexOf("/") + 1, fullname.indexOf(".zip"));
                    try {
                        result = new URL("jar:" + result + "!/" + filename);
                    }
                    catch (MalformedURLException e) {
                        result = null;
                    }
                }
                if (result == null) {
                    result = super.toURL(systemId);
                }
                if (result != null) {
                    this.urlCache.put(systemId, result);
                }
            }
            return result;
        }
    }
}

