/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.metadata.validator;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import org.dentaku.services.metadata.validator.ValidatingVisitor;
import org.dentaku.services.metadata.validator.VisitorException;
import org.omg.uml.foundation.core.ModelElement;

public abstract class ValidatingVisitorBase
implements ValidatingVisitor {
    protected final Map superclassCache = new HashMap();
    protected final Set methodFilter = new HashSet();

    protected ValidatingVisitorBase() {
        try {
            this.methodFilter.add(ValidatingVisitorBase.class.getMethod("visit", ModelElement.class, Object.class));
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationError("couldn't reflect our own visit method!");
        }
    }

    public void visit(ModelElement element, Object context) throws VisitorException {
        Class<?> c = element.getClass();
        ListOrderedSet interfaces = this.getVisitMethodsForClass(c);
        Iterator it = interfaces.iterator();
        while (it.hasNext()) {
            Method m = (Method)it.next();
            try {
                m.invoke((Object)this, element, context);
            }
            catch (Exception e1) {
                throw new VisitorException(e1);
            }
        }
    }

    private ListOrderedSet getVisitMethodsForClass(Class c) {
        ListOrderedSet result = (ListOrderedSet)this.superclassCache.get(c);
        if (result == null) {
            result = new ListOrderedSet();
            this.superclassCache.put(c, result);
            for (Class current = c; current != null; current = current.getSuperclass()) {
                Class<?>[] interfaces = current.getInterfaces();
                try {
                    Method method = this.getClass().getMethod("visit", current, class$java$lang$Object == null ? ValidatingVisitorBase.class$("java.lang.Object") : class$java$lang$Object);
                    if (!this.methodFilter.contains(method)) {
                        result.add((Object)method);
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> thisInterface = interfaces[i];
                    result.addAll((Collection)this.getVisitMethodsForClass(thisInterface));
                }
            }
        }
        return result;
    }
}

