/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.metadata;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassCache;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.ModelBuilder;
import com.thoughtworks.qdox.parser.structs.ClassDef;
import com.thoughtworks.qdox.parser.structs.FieldDef;
import com.thoughtworks.qdox.parser.structs.MethodDef;
import com.thoughtworks.qdox.parser.structs.TagDef;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dentaku.services.metadata.JMIMetadataProviderBase;
import org.dentaku.services.metadata.RepositoryReader;
import org.generama.GeneramaException;
import org.generama.QDoxCapableMetadataProvider;
import org.netbeans.jmiimpl.omg.uml.foundation.core.ClassifierImpl;
import org.netbeans.jmiimpl.omg.uml.foundation.core.ModelElementImpl;
import org.netbeans.jmiimpl.omg.uml.foundation.core.OperationImpl;
import org.netbeans.jmiimpl.omg.uml.foundation.core.TaggedValueImpl;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.Comment;
import org.omg.uml.foundation.core.Interface;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.core.Stereotype;
import org.omg.uml.foundation.core.TaggedValue;

public class QDoxMetadataProvider
extends JMIMetadataProviderBase
implements QDoxCapableMetadataProvider,
JavaClassCache {
    private ClassLibrary classLibrary = new ClassLibrary((JavaClassCache)this);
    private Collection metadata;
    private Map classes;
    private Map qdoxJMIMap;

    public QDoxMetadataProvider() {
    }

    public QDoxMetadataProvider(RepositoryReader reader) {
        super(reader);
    }

    public Collection getMetadata() throws GeneramaException {
        this.setupMetadata();
        return this.classes.values();
    }

    public Collection getJMIMetadata() {
        this.setupMetadata();
        return this.metadata;
    }

    private void setupMetadata() {
        try {
            if (this.classes == null) {
                this.metadata = this.getModel().getCore().getModelElement().refAllOfType();
                this.classLibrary.addDefaultLoader();
                Collection c = this.getModel().getCore().getClassifier().refAllOfType();
                this.classes = new HashMap(c.size());
                this.qdoxJMIMap = new HashMap(c.size());
                for (Classifier classifier : c) {
                    JavaClass qdoxClass = this.createJMIClass(classifier);
                    this.classes.put(classifier.getName(), qdoxClass);
                    this.qdoxJMIMap.put(qdoxClass, classifier);
                }
            }
        }
        catch (Exception e) {
            throw new GeneramaException("problem loading metadata", (Throwable)e);
        }
    }

    public Classifier mapObjectToClassifier(Object object) {
        if (object instanceof AbstractJavaEntity) {
            return (Classifier)this.qdoxJMIMap.get(object);
        }
        throw new IllegalArgumentException("Unknown type to map");
    }

    private void addClass(JavaClass cls) {
        this.classes.put(cls.getFullyQualifiedName(), cls);
        cls.setJavaClassCache((JavaClassCache)this);
    }

    public JavaClass getClassByName(String name) {
        if (name == null) {
            return null;
        }
        JavaClass result = (JavaClass)this.classes.get(name);
        if (result == null) {
            result = null;
            if (result != null) {
                this.addClass(result);
            } else {
                result = this.createUnknownClass(name);
            }
        }
        return result;
    }

    public JavaClass[] getClasses() {
        JavaClass[] result = this.classes.values().toArray(new JavaClass[this.classes.size()]);
        return result;
    }

    private JavaClass createUnknownClass(String name) {
        ModelBuilder unknownBuilder = new ModelBuilder(this.classLibrary, (DocletTagFactory)this.docletTagFactory);
        ClassDef classDef = new ClassDef();
        classDef.name = name;
        unknownBuilder.beginClass(classDef);
        unknownBuilder.endClass();
        JavaSource unknownSource = unknownBuilder.getSource();
        JavaClass result = unknownSource.getClasses()[0];
        return result;
    }

    private JavaClass createJMIClass(Classifier classifier) {
        ModelBuilder binaryBuilder = new ModelBuilder(this.classLibrary, (DocletTagFactory)this.docletTagFactory);
        String packageName = super.getOriginalPackageName(classifier);
        binaryBuilder.addPackage(packageName);
        ClassDef classDef = new ClassDef();
        classDef.name = classifier.getName();
        Collection interfaces = ((ClassifierImpl)classifier).getAbstractions();
        if (classifier instanceof Interface) {
            classDef.type = "interface";
            for (Classifier anInterface : interfaces) {
                classDef.extendz.add(anInterface.getName());
            }
        } else {
            for (Classifier anInterface : interfaces) {
                classDef.implementz.add(anInterface.getName());
            }
            Classifier superclass = (Classifier)((ClassifierImpl)classifier).getSuperclass();
            if (superclass != null) {
                classDef.extendz.add(superclass.getName());
            }
        }
        this.addTags(classifier, binaryBuilder);
        binaryBuilder.beginClass(classDef);
        Collection methods = ((ClassifierImpl)classifier).getOperations();
        for (Operation pOperation : methods) {
            if (pOperation.getOwner() != classifier) continue;
            this.addMethodOrConstructor(pOperation, binaryBuilder);
        }
        Collection fields = ((ClassifierImpl)classifier).getAttributes();
        for (Attribute attribute : fields) {
            if (attribute.getOwner() != classifier) continue;
            this.addField(attribute, binaryBuilder);
        }
        binaryBuilder.endClass();
        JavaSource binarySource = binaryBuilder.getSource();
        JavaClass result = binarySource.getClasses()[0];
        result.setJavaClassCache((JavaClassCache)this);
        return result;
    }

    private void addStereotype(Stereotype pClassifier, ModelBuilder binaryBuilder) {
        for (TaggedValue taggedValue : pClassifier.getTaggedValue()) {
            binaryBuilder.addJavaDocTag(new TagDef(taggedValue.getName(), ((TaggedValueImpl)taggedValue).getValue()));
        }
    }

    private void addTags(ModelElement classifier, ModelBuilder binaryBuilder) {
        Collection comments = classifier.getComment();
        String comment = "";
        Iterator it = comments.iterator();
        while (it.hasNext()) {
            comment = comment + ((Comment)it.next()).getBody();
        }
        binaryBuilder.addJavaDoc(comment);
        for (Stereotype stereotype : classifier.getStereotype()) {
            this.addStereotype(stereotype, binaryBuilder);
        }
        for (TaggedValueImpl taggedValue : ((ModelElementImpl)classifier).getTaggedValue()) {
            if (!taggedValue.getName().startsWith("@")) continue;
            binaryBuilder.addJavaDocTag(new TagDef(taggedValue.getName().substring(1), taggedValue.getValue()));
        }
    }

    private void addField(Attribute field, ModelBuilder binaryBuilder) {
        FieldDef fieldDef = new FieldDef();
        Classifier fieldType = field.getType();
        fieldDef.name = field.getName();
        if (fieldType != null) {
            fieldDef.type = fieldType.getName();
        }
        this.addTags(field, binaryBuilder);
        binaryBuilder.addField(fieldDef);
    }

    private void addMethodOrConstructor(Operation operation, ModelBuilder binaryBuilder) {
        int j;
        Classifier[] parameterTypes;
        Classifier[] exceptions;
        MethodDef methodDef = new MethodDef();
        int lastDot = operation.getName().lastIndexOf(46);
        methodDef.name = operation.getName().substring(lastDot + 1);
        if (((OperationImpl)operation).getTaggedValue("Constructor") != null) {
            methodDef.constructor = true;
            exceptions = ((OperationImpl)operation).getExceptionTypes();
            parameterTypes = ((OperationImpl)operation).getParameterTypes();
        } else {
            methodDef.constructor = false;
            exceptions = ((OperationImpl)operation).getExceptionTypes();
            parameterTypes = ((OperationImpl)operation).getParameterTypes();
            methodDef.returns = ((OperationImpl)operation).getReturnTypeName();
        }
        for (j = 0; j < exceptions.length; ++j) {
            Classifier exception = exceptions[j];
            methodDef.exceptions.add(exception.getName());
        }
        for (j = 0; j < parameterTypes.length; ++j) {
            FieldDef param = new FieldDef();
            Classifier parameterType = parameterTypes[j];
            param.name = "p" + j;
            param.type = parameterType.getName();
            methodDef.params.add(param);
        }
        this.addTags(operation, binaryBuilder);
        binaryBuilder.addMethod(methodDef);
    }

    public String getOriginalFileName(Object metadata) {
        String result;
        if (metadata instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)metadata;
            result = javaClass.getName() + ".java";
        } else {
            result = super.getOriginalFileName(metadata);
        }
        return result;
    }

    public String getOriginalPackageName(Object metadata) {
        if (metadata instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)metadata;
            return javaClass.getPackage();
        }
        return super.getOriginalPackageName(metadata);
    }
}

