/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.metadata.dbmapping;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbMappingTable {
    private static HashMap mappings;

    public String getJDBCType(String javaType) {
        TypeMapping mapping = (TypeMapping)this.getConfigurationMapping().get(javaType);
        if (mapping != null) {
            return mapping.jdbcType;
        }
        return "missing jdbc mapping for " + javaType;
    }

    public String getSQLType(String javaType, String desiredFieldLength) {
        TypeMapping mapping = (TypeMapping)this.getConfigurationMapping().get(javaType);
        if (mapping != null) {
            if (desiredFieldLength != null && desiredFieldLength.length() > 0) {
                return MessageFormat.format(mapping.sqlPattern, desiredFieldLength);
            }
            return MessageFormat.format(mapping.sqlPattern, mapping.sqlDefaultLength);
        }
        return "missing jdbc mapping for " + javaType;
    }

    public Map getConfigurationMapping() throws RuntimeException {
        if (mappings == null) {
            byte[] buf = new byte[4096];
            int ptr = 0;
            int read = 0;
            String input = "";
            InputStream in = this.getClass().getResourceAsStream("DbMappingTable.xml");
            try {
                do {
                    read = in.read(buf, ptr += read, 4096);
                    input = input + new String(buf).substring(0, read);
                } while (read == 4096);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new XppDomDriver());
            xstream.alias("mapping", TypeMapping.class);
            List configuration = (List)xstream.fromXML(input);
            mappings = new HashMap();
            for (TypeMapping typeMapping : configuration) {
                for (String s : typeMapping.typeNames) {
                    mappings.put(s, typeMapping);
                }
            }
        }
        return mappings;
    }

    public static class TypeMapping {
        public List typeNames;
        public String jdbcType;
        public String sqlPattern;
        public String sqlDefaultLength;
    }
}

