/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.gentaku.cartridge;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.dentaku.gentaku.cartridge.JMIHelper;
import org.dentaku.services.metadata.JMICapableMetadataProvider;
import org.generama.MetadataProvider;
import org.generama.Plugin;
import org.generama.TemplateEngine;
import org.generama.WriterMapper;
import org.generama.defaults.FileWriterMapper;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Stereotype;
import org.omg.uml.foundation.datatypes.ChangeableKindEnum;
import org.omg.uml.foundation.datatypes.ScopeKindEnum;
import org.omg.uml.foundation.datatypes.VisibilityKindEnum;

public abstract class JavaPluginBase
extends Plugin {
    private JMICapableMetadataProvider metadataProvider;
    private boolean createonly;
    protected String[] stereotypes;

    public JavaPluginBase(String[] stereosTypes, TemplateEngine templateEngine, JMICapableMetadataProvider metadataProvider, WriterMapper writerMapper) {
        super(templateEngine, (MetadataProvider)metadataProvider, (WriterMapper)new CheckFileWriterMapper(writerMapper));
        this.metadataProvider = metadataProvider;
        this.setCreateonly(true);
        this.stereotypes = stereosTypes;
    }

    public boolean shouldGenerate(Object metadata) {
        if (!(metadata instanceof ModelElement)) {
            return false;
        }
        for (int i = 0; i < this.stereotypes.length; ++i) {
            if (!JavaPluginBase.matchesStereotype((ModelElement)metadata, this.stereotypes[i])) continue;
            return true;
        }
        return false;
    }

    public Collection getMetadata() {
        return this.metadataProvider.getJMIMetadata();
    }

    protected void populateContextMap(Map ctx) {
        super.populateContextMap(ctx);
        ctx.put("jmiHelper", new JMIHelper());
        ctx.put("CK_ADD_ONLY", ChangeableKindEnum.CK_ADD_ONLY);
        ctx.put("CK_CHANGEABLE", ChangeableKindEnum.CK_CHANGEABLE);
        ctx.put("CK_FROZEN", ChangeableKindEnum.CK_FROZEN);
        ctx.put("VK_PACKAGE", VisibilityKindEnum.VK_PACKAGE);
        ctx.put("VK_PRIVATE", VisibilityKindEnum.VK_PRIVATE);
        ctx.put("VK_PROTECTED", VisibilityKindEnum.VK_PROTECTED);
        ctx.put("VK_PUBLIC", VisibilityKindEnum.VK_PUBLIC);
        ctx.put("SK_CLASSIFIER", ScopeKindEnum.SK_CLASSIFIER);
        ctx.put("SK_INSTANCE", ScopeKindEnum.SK_INSTANCE);
    }

    public String getDestinationClassname(Object metadata) {
        String destinationFilename = this.getDestinationFilename(metadata);
        return destinationFilename.substring(0, destinationFilename.indexOf(46));
    }

    public String getDestinationFullyQualifiedClassName(Object metadata) {
        String packageName = this.getDestinationPackage(metadata);
        packageName = packageName.equals("") ? "" : packageName + ".";
        return packageName + this.getDestinationClassname(metadata);
    }

    public static boolean matchesStereotype(ModelElement object, String stereotypeName) {
        if (object == null || stereotypeName == null) {
            return false;
        }
        Iterator i = object.getStereotype().iterator();
        while (i.hasNext()) {
            Stereotype stereo = (Stereotype)i.next();
            if (!stereotypeName.equals(stereo.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isCreateonly() {
        return this.createonly;
    }

    public void setCreateonly(boolean createOnly) {
        this.createonly = createOnly;
        ((CheckFileWriterMapper)this.getWriterMapper()).setCreateonly(createOnly);
    }

    public static String toDatabaseAttributeName(String s, String separator) {
        StringBuffer databaseAttributeName = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(JavaPluginBase.lowerCaseFirstLetter(s));
        char character = iter.first();
        while (character != '\uffff') {
            if (Character.isUpperCase(character)) {
                databaseAttributeName.append(separator);
            }
            character = Character.toUpperCase(character);
            databaseAttributeName.append(character);
            character = iter.next();
        }
        return databaseAttributeName.toString();
    }

    public String fromDatabaseAttributeName(String s, String separator) {
        if (s == null) {
            return null;
        }
        String[] tok = s.split(separator);
        StringBuffer databaseAttributeName = new StringBuffer();
        databaseAttributeName.append(JavaPluginBase.lowerCaseFirstLetter(tok[0]));
        for (int i = 1; i < tok.length; ++i) {
            databaseAttributeName.append(this.upperCaseFirstLetter(tok[i]));
        }
        return databaseAttributeName.toString();
    }

    public static String lowerCaseFirstLetter(String s) {
        if (s != null && s.length() > 0) {
            return s.substring(0, 1).toLowerCase() + s.substring(1);
        }
        return s;
    }

    public String upperCaseFirstLetter(String s) {
        if (s != null && s.length() > 0) {
            return s.substring(0, 1).toUpperCase() + s.substring(1);
        }
        return s;
    }

    public JMICapableMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    private static class CheckFileWriterMapper
    implements WriterMapper {
        private WriterMapper delegate;
        private boolean createOnly;

        public CheckFileWriterMapper(WriterMapper delegate) {
            this.delegate = delegate;
        }

        public Writer getWriter(Object metadata, Plugin plugin) throws IOException {
            Writer result = null;
            if (this.delegate instanceof FileWriterMapper) {
                String pakkage = plugin.getDestinationPackage(metadata);
                String packagePath = pakkage.replace('.', '/');
                File dir = new File(plugin.getDestdirFile(), packagePath);
                dir.mkdirs();
                String filename = plugin.getDestinationFilename(metadata);
                File out = new File(dir, filename);
                if (!this.createOnly || !out.exists()) {
                    try {
                        result = new OutputStreamWriter((OutputStream)new FileOutputStream(out), plugin.getEncoding());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IOException(e.toString());
                    }
                }
            } else {
                result = this.delegate.getWriter(metadata, plugin);
            }
            return result;
        }

        public boolean isCreateonly() {
            return this.createOnly;
        }

        public void setCreateonly(boolean createOnly) {
            this.createOnly = createOnly;
        }
    }
}

