/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.aspectj;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.aspectj.AbstractAjcCompiler;
import org.codehaus.plexus.util.Scanner;

@Mojo(name="test-compile", threadSafe=true, defaultPhase=LifecyclePhase.TEST_COMPILE, requiresDependencyResolution=ResolutionScope.TEST)
public class AjcTestCompileMojo
extends AbstractAjcCompiler {
    protected static final String MAVEN_TEST_SKIP = "maven.test.skip";
    @Parameter(defaultValue="false")
    protected boolean weaveMainSourceFolder = false;
    @Parameter(defaultValue="true")
    protected boolean weaveWithAspectsInMainSourceFolder = true;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.testOutputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File argumentFileDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/aspectj-maven-plugin")
    private File generatedTestSourcesDirectory;
    @Parameter
    private Scanner[] testSources;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.isSkipTestCompile()) {
            this.getLog().info((CharSequence)"Not compiling test sources");
            return;
        }
        super.execute();
    }

    @Override
    protected List<String> getClasspathDirectories() {
        ArrayList<String> outputDirectories = new ArrayList<String>();
        outputDirectories.add(this.project.getBuild().getTestOutputDirectory());
        outputDirectories.add(this.project.getBuild().getOutputDirectory());
        return outputDirectories;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected File getArgumentFileDirectory() {
        return this.argumentFileDirectory;
    }

    @Override
    public File getGeneratedSourcesDirectory() {
        return this.generatedTestSourcesDirectory;
    }

    @Override
    protected List<String> getSourceDirectories() {
        ArrayList<String> sourceDirs = new ArrayList<String>(this.project.getTestCompileSourceRoots());
        if (this.weaveMainSourceFolder) {
            sourceDirs.addAll(this.project.getCompileSourceRoots());
        }
        return sourceDirs;
    }

    @Override
    protected Scanner[] getJavaSources() {
        return this.testSources;
    }

    @Override
    protected String getAdditionalAspectPaths() {
        String additionalPath = null;
        if (this.weaveWithAspectsInMainSourceFolder) {
            additionalPath = this.project.getBuild().getOutputDirectory();
        }
        return additionalPath;
    }

    private boolean isSkipTestCompile() {
        String skipTestCompile = System.getProperty(MAVEN_TEST_SKIP);
        return Boolean.parseBoolean(skipTestCompile);
    }

    @Override
    protected boolean isBuildNeeded() throws MojoExecutionException {
        return super.isBuildNeeded() || this.hasClassPathClassesChanged(this.getArgumentFileDirectory(), true);
    }
}

