/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoWriteException;
import com.mongodb.WriteConcern;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ValidationOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import dev.morphia.AdvancedDatastore;
import dev.morphia.Datastore;
import dev.morphia.DeleteOptions;
import dev.morphia.InsertManyOptions;
import dev.morphia.InsertOneOptions;
import dev.morphia.MissingIdException;
import dev.morphia.ModifyOptions;
import dev.morphia.ReplaceOptions;
import dev.morphia.UpdateOptions;
import dev.morphia.VersionMismatchException;
import dev.morphia.aggregation.Aggregation;
import dev.morphia.aggregation.AggregationImpl;
import dev.morphia.aggregation.AggregationPipeline;
import dev.morphia.aggregation.AggregationPipelineImpl;
import dev.morphia.aggregation.codecs.AggregationCodecProvider;
import dev.morphia.annotations.CappedAt;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.ShardKeys;
import dev.morphia.annotations.ShardOptions;
import dev.morphia.annotations.Validation;
import dev.morphia.annotations.internal.IndexHelper;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.config.MorphiaConfig;
import dev.morphia.internal.CollectionConfigurable;
import dev.morphia.internal.CollectionConfiguration;
import dev.morphia.internal.ReadConfigurable;
import dev.morphia.internal.WriteConfigurable;
import dev.morphia.mapping.EntityModelImporter;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.ShardKeyType;
import dev.morphia.mapping.codec.EnumCodecProvider;
import dev.morphia.mapping.codec.MorphiaCodecProvider;
import dev.morphia.mapping.codec.MorphiaTypesCodecProvider;
import dev.morphia.mapping.codec.PrimitiveCodecRegistry;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.MergingEncoder;
import dev.morphia.mapping.codec.pojo.MorphiaCodec;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.reader.DocumentReader;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.query.CountOptions;
import dev.morphia.query.FindAndDeleteOptions;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.QueryFactory;
import dev.morphia.query.Update;
import dev.morphia.query.UpdateException;
import dev.morphia.query.UpdateOperations;
import dev.morphia.query.UpdateOpsImpl;
import dev.morphia.query.filters.Filters;
import dev.morphia.query.updates.UpdateOperator;
import dev.morphia.query.updates.UpdateOperators;
import dev.morphia.sofia.Sofia;
import dev.morphia.transactions.MorphiaSessionImpl;
import dev.morphia.transactions.MorphiaTransaction;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bson.BsonReader;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MorphiaInternal
public class DatastoreImpl
implements AdvancedDatastore {
    private static final Logger LOG = LoggerFactory.getLogger(Datastore.class);
    private final MongoClient mongoClient;
    private final Mapper mapper;
    private final QueryFactory queryFactory;
    private final CodecRegistry codecRegistry;
    public List<MorphiaCodecProvider> morphiaCodecProviders = new ArrayList<MorphiaCodecProvider>();
    private MongoDatabase database;
    private DatastoreOperations operations;

    public DatastoreImpl(MongoClient client, MorphiaConfig config) {
        this.mongoClient = client;
        this.database = this.mongoClient.getDatabase(config.database());
        this.mapper = new Mapper(config);
        this.queryFactory = this.mapper.getConfig().queryFactory();
        this.importModels();
        this.codecRegistry = this.buildRegistry();
        this.database = this.database.withCodecRegistry(this.codecRegistry);
        this.operations = new CollectionOperations();
        config.packages().forEach(packageName -> {
            Sofia.logMappingPackage(packageName, new Locale[0]);
            this.mapper.map((String)packageName);
        });
        if (config.applyCaps().booleanValue()) {
            this.applyCaps();
        }
        if (config.applyIndexes().booleanValue()) {
            this.applyIndexes();
        }
        if (config.applyDocumentValidations().booleanValue()) {
            this.applyDocumentValidations();
        }
    }

    public DatastoreImpl(DatastoreImpl datastore) {
        this.mongoClient = datastore.mongoClient;
        this.database = this.mongoClient.getDatabase(datastore.mapper.getConfig().database());
        this.mapper = datastore.mapper.copy();
        this.queryFactory = datastore.queryFactory;
        this.operations = datastore.operations;
        this.codecRegistry = this.buildRegistry();
    }

    private CodecRegistry buildRegistry() {
        this.morphiaCodecProviders.add(new MorphiaCodecProvider(this));
        CodecRegistry codecRegistry = this.database.getCodecRegistry();
        ArrayList<Object> providers = new ArrayList<Object>();
        this.mapper.getConfig().codecProvider().ifPresent(providers::add);
        providers.addAll(List.of(new MorphiaTypesCodecProvider(this), new PrimitiveCodecRegistry(codecRegistry), new EnumCodecProvider(), new AggregationCodecProvider(this)));
        providers.addAll(this.morphiaCodecProviders);
        providers.add(codecRegistry);
        codecRegistry = CodecRegistries.fromProviders(providers);
        return codecRegistry;
    }

    @Override
    public <T> void insert(T entity, InsertOneOptions options) {
        MongoCollection<?> collection = this.configureCollection(options, this.getCollection(entity.getClass()));
        VersionBumpInfo info = this.updateVersioning(entity);
        try {
            this.operations.insertOne(collection, entity, options);
        }
        catch (MongoWriteException e) {
            info.rollbackVersion();
            throw e;
        }
    }

    @Override
    public <T> void insert(List<T> entities, InsertManyOptions options) {
        if (entities.isEmpty()) {
            return;
        }
        Map<Class<?>, List<T>> grouped = this.groupByType(entities, model -> false);
        String alternate = options.collection();
        if (alternate != null && grouped.size() > 1) {
            Sofia.logInsertManyAlternateCollection(alternate, new Locale[0]);
        }
        grouped.forEach((key, list) -> {
            List<VersionBumpInfo> infos = list.stream().map(this::updateVersioning).collect(Collectors.toList());
            try {
                MongoCollection collection = this.configureCollection(options, this.getCollection((Class)key));
                this.operations.insertMany(collection, list, options);
            }
            catch (MongoException e) {
                infos.forEach(VersionBumpInfo::rollbackVersion);
                throw e;
            }
        });
    }

    @Override
    public Aggregation<Document> aggregate(String source) {
        return new AggregationImpl<Document>(this, this.getDatabase().getCollection(source));
    }

    @Override
    public <T> Aggregation<T> aggregate(Class<T> source) {
        return new AggregationImpl<T>(this, source, this.getCollection(source));
    }

    public AggregationPipeline createAggregation(Class source) {
        return new AggregationPipelineImpl(this, this.getCollection(source), source);
    }

    @Override
    public <T> UpdateOperations<T> createUpdateOperations(Class<T> clazz) {
        return new UpdateOpsImpl<T>(this, clazz);
    }

    @NonNull
    @MorphiaInternal
    public <T> MongoCollection<T> configureCollection(CollectionConfiguration options, MongoCollection<T> collection) {
        if (options instanceof CollectionConfigurable) {
            collection = ((CollectionConfigurable)options).prepare(collection, this.getDatabase());
        }
        if (options instanceof ReadConfigurable) {
            collection = ((ReadConfigurable)options).prepare(collection);
        }
        if (options instanceof WriteConfigurable) {
            collection = ((WriteConfigurable)options).configure(collection);
        }
        return collection;
    }

    @Override
    public <T> DeleteResult delete(T entity, DeleteOptions options) {
        if (entity instanceof Class) {
            throw new MappingException(Sofia.deleteWithClass(entity.getClass().getName(), new Locale[0]));
        }
        Object id = this.mapper.getId(entity);
        return id != null ? this.find(entity.getClass()).filter(Filters.eq("_id", id)).delete(options) : new NoDeleteResult();
    }

    @Override
    public <T> DeleteResult delete(T entity) {
        return this.delete(entity, new DeleteOptions().writeConcern(this.mapper.getWriteConcern(entity.getClass())));
    }

    public void applyDocumentValidations() {
        for (EntityModel model : this.mapper.getMappedEntities()) {
            this.enableDocumentValidation(model);
        }
    }

    @Override
    public void enableDocumentValidation() {
        Sofia.logConfiguredOperation("Datastore#enableDocumentValidation()", new Locale[0]);
        for (EntityModel model : this.mapper.getMappedEntities()) {
            this.enableDocumentValidation(model);
        }
    }

    @Override
    public void ensureIndexes() {
        Sofia.logConfiguredOperation("Datastore#ensureIndexes", new Locale[0]);
        this.applyIndexes();
    }

    public void applyIndexes() {
        if (this.mapper.getMappedEntities().isEmpty()) {
            LOG.warn(Sofia.noMappedClasses(new Locale[0]));
        }
        IndexHelper indexHelper = new IndexHelper(this.mapper);
        for (EntityModel model : this.mapper.getMappedEntities()) {
            if (model.getIdProperty() == null) continue;
            indexHelper.createIndex(this.getCollection(model.getType()), model);
        }
    }

    public <T> void ensureIndexes(Class<T> type) {
        EntityModel model = this.mapper.getEntityModel(type);
        IndexHelper indexHelper = new IndexHelper(this.mapper);
        if (model.getIdProperty() != null) {
            indexHelper.createIndex(this.getCollection(type), model);
        }
    }

    @Override
    public <T> Query<T> find(Class<T> type) {
        return this.queryFactory.createQuery(this, type);
    }

    @Override
    public <T> Query<T> find(Class<T> type, Document nativeQuery) {
        return this.queryFactory.createQuery((Datastore)this, type, nativeQuery);
    }

    @Override
    public <T> Query<T> find(String collection, Class<T> type) {
        return this.queryFactory.createQuery((Datastore)this, collection, type);
    }

    @Override
    public <T> Query<T> find(String collection) {
        Class type = this.mapper.getClassFromCollection(collection);
        return this.queryFactory.createQuery(this, type);
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public <T> MongoCollection<T> getCollection(Class<T> type) {
        EntityModel entityModel = this.mapper.getEntityModel(type);
        String collectionName = entityModel.getCollectionName();
        MongoCollection collection = this.getDatabase().getCollection(collectionName, type).withCodecRegistry(this.codecRegistry);
        Entity annotation = entityModel.getEntityAnnotation();
        if (annotation != null && !annotation.concern().equals("")) {
            collection = collection.withWriteConcern(WriteConcern.valueOf((String)annotation.concern()));
        }
        return collection;
    }

    @Override
    public MongoDatabase getDatabase() {
        return this.database;
    }

    @Override
    public String getLoggedQuery(FindOptions options) {
        if (options.isLogQuery()) {
            Document command;
            Document filter;
            String json = "{}";
            Document first = (Document)this.getDatabase().getCollection("system.profile").find((Bson)new Document("command.comment", (Object)("logged query: " + options.queryLogId())), Document.class).projection((Bson)new Document("command.filter", (Object)1)).first();
            if (first != null && (filter = (Document)(command = (Document)first.get((Object)"command")).get((Object)"filter")) != null) {
                json = filter.toJson((Encoder)this.codecRegistry.get(Document.class));
            }
            return json;
        }
        throw new IllegalStateException(Sofia.queryNotLogged(new Locale[0]));
    }

    @Override
    public <T> T replace(T entity, ReplaceOptions options) {
        Object id;
        MongoCollection<?> collection = this.configureCollection(options, this.getCollection(entity.getClass()));
        EntityModel entityModel = this.mapper.getEntityModel(entity.getClass());
        PropertyModel idProperty = entityModel.getIdProperty();
        Object object = id = idProperty != null ? idProperty.getValue(entity) : null;
        if (id == null) {
            throw new MissingIdException();
        }
        VersionBumpInfo info = this.updateVersioning(entity);
        try {
            Document filter = new Document("_id", id);
            info.filter(filter);
            entityModel.getShardKeys().forEach(property -> filter.put(property.getMappedName(), property.getValue(entity)));
            UpdateResult updateResult = this.operations.replaceOne(collection, entity, filter, options);
            if (updateResult.getModifiedCount() != 1L) {
                if (info.versioned()) {
                    info.rollbackVersion();
                    throw new VersionMismatchException(entity.getClass(), id);
                }
                if (!entityModel.getShardKeys().isEmpty()) {
                    throw new MappingException(Sofia.noShardKeyMatch(entityModel.getShardKeys().stream().map(PropertyModel::getMappedName).collect(Collectors.joining(", ")), new Locale[0]));
                }
                throw new MappingException(Sofia.noDocumentsUpdated(id, new Locale[0]));
            }
        }
        catch (MongoWriteException e) {
            info.rollbackVersion();
            throw e;
        }
        return entity;
    }

    private void applyCaps() {
        List collectionNames = (List)this.database.listCollectionNames().into(new ArrayList());
        for (EntityModel model : this.mapper.getMappedEntities()) {
            CappedAt cappedAt;
            Entity entityAnnotation = model.getEntityAnnotation();
            if (entityAnnotation == null || (cappedAt = entityAnnotation.cap()).value() <= 0L && cappedAt.count() <= 0L) continue;
            CappedAt cap = entityAnnotation.cap();
            String collName = model.getCollectionName();
            CreateCollectionOptions dbCapOpts = new CreateCollectionOptions().capped(true);
            if (cap.value() > 0L) {
                dbCapOpts.sizeInBytes(cap.value());
            }
            if (cap.count() > 0L) {
                dbCapOpts.maxDocuments(cap.count());
            }
            MongoDatabase database = this.getDatabase();
            if (collectionNames.contains(collName)) {
                Document dbResult = database.runCommand((Bson)new Document("collstats", (Object)collName));
                if (dbResult.getBoolean((Object)"capped", false)) {
                    LOG.debug("MongoCollection already exists and is capped already; doing nothing. " + dbResult);
                    continue;
                }
                LOG.warn("MongoCollection already exists with same name(" + collName + ") and is not capped; not creating capped version!");
                continue;
            }
            this.getDatabase().createCollection(collName, dbCapOpts);
            LOG.debug("Created capped MongoCollection (" + collName + ") with opts " + dbCapOpts);
        }
    }

    @Override
    public void ensureCaps() {
        Sofia.logConfiguredOperation("ensureCaps", new Locale[0]);
        this.applyCaps();
    }

    @Override
    public <T> T merge(T entity, InsertOneOptions options) {
        Object id = this.mapper.getId(entity);
        if (id == null) {
            throw new MappingException("Could not get id for " + entity.getClass().getName());
        }
        VersionBumpInfo info = this.updateVersioning(entity);
        Query<?> query = this.find(entity.getClass()).filter(Filters.eq("_id", id));
        info.filter(query);
        Update<?> update = !options.unsetMissing() ? query.update(UpdateOperators.set(entity), new UpdateOperator[0]) : new MergingEncoder(query, (MorphiaCodec)this.codecRegistry.get(entity.getClass())).encode(entity);
        UpdateResult execute = update.execute(new UpdateOptions().writeConcern(options.writeConcern()));
        if (execute.getMatchedCount() != 1L) {
            if (info.versioned()) {
                info.rollbackVersion();
                throw new VersionMismatchException(entity.getClass(), id);
            }
            throw new UpdateException(Sofia.noMatchingDocuments(new Locale[0]));
        }
        return this.find(entity.getClass()).filter(Filters.eq("_id", id)).iterator(new FindOptions().limit(1)).next();
    }

    protected MongoClient getMongoClient() {
        return this.mongoClient;
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    @Override
    public void shardCollections() {
        List<EntityModel> entities = this.getMapper().getMappedEntities().stream().filter(m -> m.getAnnotation(ShardKeys.class) != null).collect(Collectors.toList());
        this.operations.runCommand(new Document("enableSharding", (Object)this.database.getName()));
        entities.forEach(e -> {
            if (!this.shardCollection((EntityModel)e).containsKey((Object)"collectionsharded")) {
                throw new MappingException(Sofia.cannotShardCollection(this.getDatabase().getName(), e.getCollectionName(), new Locale[0]));
            }
        });
    }

    @Override
    public <T> T merge(T entity) {
        return this.merge(entity, new InsertOneOptions());
    }

    protected Document shardCollection(EntityModel model) {
        ShardKeys shardKeys = model.getAnnotation(ShardKeys.class);
        if (shardKeys != null) {
            Document collstats = this.database.runCommand((Bson)new Document("collstats", (Object)model.getCollectionName()));
            if (collstats.getBoolean((Object)"sharded", false)) {
                LOG.debug("MongoCollection already exists and is sharded already; doing nothing. " + collstats);
            } else {
                ShardOptions options = shardKeys.options();
                Document command = new Document("shardCollection", (Object)String.format("%s.%s", this.getDatabase().getName(), model.getCollectionName())).append("unique", (Object)options.unique()).append("presplitHashedZones", (Object)options.presplitHashedZones());
                boolean hashed = Arrays.stream(shardKeys.value()).anyMatch(k -> k.type() == ShardKeyType.HASHED);
                if (hashed && options.numInitialChunks() != -1) {
                    command.append("numInitialChunks", (Object)options.numInitialChunks());
                }
                if (collstats.get((Object)"collation") != null) {
                    command.append("collation", (Object)new Document("locale", (Object)"simple"));
                }
                command.append("key", (Object)Arrays.stream(shardKeys.value()).map(k -> new Document(k.value(), this.queryForm(k.type()))).reduce(new Document(), (a, m) -> {
                    a.putAll((Map)m);
                    return a;
                }));
                return this.operations.runCommand(command);
            }
        }
        return new Document();
    }

    private Object queryForm(ShardKeyType type) {
        switch (type) {
            case HASHED: {
                return "hashed";
            }
            case RANGED: {
                return 1;
            }
        }
        throw new IllegalStateException("Every shard key type should be handled.");
    }

    @Override
    public <T> List<T> save(List<T> entities, InsertManyOptions options) {
        if (entities.isEmpty()) {
            return List.of();
        }
        LinkedHashMap<Class, List> grouped = new LinkedHashMap<Class, List>();
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object entity : entities) {
            Class<?> clazz = entity.getClass();
            EntityModel entityModel = this.getMapper().getEntityModel(clazz);
            if (this.getMapper().getId(entity) != null || entityModel.getVersionProperty() != null) {
                list.add(entity);
                continue;
            }
            grouped.computeIfAbsent(clazz, c -> new ArrayList()).add(entity);
        }
        String alternate = options.collection();
        if (grouped.size() > 1 && alternate != null) {
            Sofia.logInsertManyAlternateCollection(alternate, new Locale[0]);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            MongoCollection<T> mongoCollection = this.configureCollection(options, this.getCollection((Class)entry.getKey()));
            this.operations.insertMany(mongoCollection, (List)entry.getValue(), options);
        }
        InsertOneOptions insertOneOptions = new InsertOneOptions().bypassDocumentValidation(options.bypassDocumentValidation()).collection(alternate).writeConcern(options.writeConcern());
        for (Object e : list) {
            this.save(e, insertOneOptions);
        }
        return entities;
    }

    @Override
    public <T> Query<T> queryByExample(T example) {
        return this.queryFactory.createQuery((Datastore)this, example.getClass(), this.toDocument(example));
    }

    @Override
    public <T> void refresh(T entity) {
        Codec<T> refreshCodec = this.getRefreshCodec(entity);
        MongoCollection<?> collection = this.getCollection(entity.getClass());
        PropertyModel idField = this.mapper.getEntityModel(entity.getClass()).getIdProperty();
        if (idField == null) {
            throw new MappingException(Sofia.idRequired(entity.getClass().getName(), new Locale[0]));
        }
        Document id = (Document)collection.find((Bson)new Document("_id", idField.getValue(entity)), Document.class).iterator().next();
        refreshCodec.decode((BsonReader)new DocumentReader(id), DecoderContext.builder().checkedDiscriminator(true).build());
    }

    @Override
    public MorphiaSessionImpl startSession() {
        return new MorphiaSessionImpl(this, this.mongoClient.startSession());
    }

    @Override
    public MorphiaSessionImpl startSession(ClientSessionOptions options) {
        return new MorphiaSessionImpl(this, this.mongoClient.startSession(options));
    }

    @Override
    public <T> T save(T entity, InsertOneOptions options) {
        this.save(this.getCollection(entity.getClass()), entity, options);
        return entity;
    }

    public DatastoreOperations operations() {
        return this.operations;
    }

    @Nullable
    protected <T> T doTransaction(MorphiaSessionImpl morphiaSession, MorphiaTransaction<T> body) {
        try (MorphiaSessionImpl morphiaSessionImpl = morphiaSession;){
            Object object = morphiaSession.getSession().withTransaction(() -> body.execute(morphiaSession));
            return (T)object;
        }
    }

    @Override
    public <T> T withTransaction(MorphiaTransaction<T> body) {
        return this.doTransaction(this.startSession(), body);
    }

    @Override
    public <T> T withTransaction(ClientSessionOptions options, MorphiaTransaction<T> transaction) {
        return this.doTransaction(this.startSession(options), transaction);
    }

    @Override
    public <T> List<T> replace(List<T> entities, ReplaceOptions options) {
        for (T entity : entities) {
            this.replace(entity, options);
        }
        return entities;
    }

    @Override
    public AggregationPipeline createAggregation(String collection, Class<?> clazz) {
        return new AggregationPipelineImpl(this, this.getDatabase().getCollection(collection), clazz);
    }

    @Override
    public <T> Query<T> createQuery(Class<T> type, Document q) {
        return this.queryFactory.createQuery((Datastore)this, type, q);
    }

    @Override
    public <T> Query<T> queryByExample(String collection, T ex) {
        return this.queryByExample(ex);
    }

    @MorphiaInternal
    public void enableValidation(EntityModel model, Validation validation) {
        String collectionName = model.getCollectionName();
        try {
            this.getDatabase().runCommand((Bson)new Document("collMod", (Object)collectionName).append("validator", (Object)Document.parse((String)validation.value())).append("validationLevel", (Object)validation.level().getValue()).append("validationAction", (Object)validation.action().getValue()));
        }
        catch (MongoCommandException e) {
            if (e.getCode() == 26) {
                this.getDatabase().createCollection(collectionName, new CreateCollectionOptions().validationOptions(new ValidationOptions().validator((Bson)Document.parse((String)validation.value())).validationLevel(validation.level()).validationAction(validation.action())));
            }
            throw e;
        }
    }

    protected DatastoreImpl operations(DatastoreOperations operations) {
        this.operations = operations;
        return this;
    }

    private <T> void save(MongoCollection collection, T entity, InsertOneOptions options) {
        collection = this.configureCollection(options, collection);
        EntityModel entityModel = this.mapper.getEntityModel(entity.getClass());
        PropertyModel idProperty = entityModel.getIdProperty();
        Object id = idProperty != null ? idProperty.getValue(entity) : null;
        VersionBumpInfo info = this.updateVersioning(entity);
        try {
            if (id == null || info.versioned() && info.newVersion() == 1L) {
                this.operations.insertOne(collection, entity, options);
            } else {
                ReplaceOptions updateOptions = new ReplaceOptions().bypassDocumentValidation(options.bypassDocumentValidation()).upsert(!info.versioned);
                Document filter = new Document("_id", id);
                info.filter(filter);
                entityModel.getShardKeys().forEach(property -> filter.put(property.getMappedName(), property.getValue(entity)));
                UpdateResult updateResult = this.operations.replaceOne(collection, entity, filter, updateOptions);
                if (info.versioned() && updateResult.getModifiedCount() != 1L) {
                    info.rollbackVersion();
                    throw new VersionMismatchException(entity.getClass(), id);
                }
            }
        }
        catch (MongoWriteException e) {
            if (info.versioned()) {
                info.rollbackVersion();
            }
            throw e;
        }
    }

    private void enableDocumentValidation(EntityModel model) {
        Validation validation = model.getAnnotation(Validation.class);
        String collectionName = model.getCollectionName();
        if (validation != null) {
            try {
                this.getDatabase().runCommand((Bson)new Document("collMod", (Object)collectionName).append("validator", (Object)Document.parse((String)validation.value())).append("validationLevel", (Object)validation.level().getValue()).append("validationAction", (Object)validation.action().getValue()));
            }
            catch (MongoCommandException e) {
                if (e.getCode() == 26) {
                    this.database.createCollection(collectionName, new CreateCollectionOptions().validationOptions(new ValidationOptions().validator((Bson)Document.parse((String)validation.value())).validationLevel(validation.level()).validationAction(validation.action())));
                }
                throw e;
            }
        }
    }

    private <T> Codec<T> getRefreshCodec(T entity) {
        for (MorphiaCodecProvider codecProvider : this.morphiaCodecProviders) {
            Codec<T> refreshCodec = codecProvider.getRefreshCodec(entity, this.codecRegistry);
            if (refreshCodec == null) continue;
            return refreshCodec;
        }
        throw new IllegalStateException(Sofia.noRefreshCodec(entity.getClass().getName(), new Locale[0]));
    }

    @NonNull
    private <T> Map<Class<?>, List<T>> groupByType(List<T> entities, Predicate<EntityModel> special) {
        LinkedHashMap grouped = new LinkedHashMap();
        for (T entity : entities) {
            Class<?> type = entity.getClass();
            EntityModel model = this.getMapper().getEntityModel(type);
            if (special.test(model)) {
                grouped.computeIfAbsent(Void.class, c -> new ArrayList()).add(entity);
                continue;
            }
            grouped.computeIfAbsent(type, c -> new ArrayList()).add(entity);
        }
        return grouped;
    }

    public boolean hasLifecycle(EntityModel model, Class<? extends Annotation> type) {
        return model.hasLifecycle(type) || this.mapper.getInterceptors().stream().anyMatch(listener -> listener.hasAnnotation(type));
    }

    private void importModels() {
        ServiceLoader<EntityModelImporter> importers = ServiceLoader.load(EntityModelImporter.class);
        for (EntityModelImporter importer : importers) {
            for (EntityModel model : importer.getModels(this.getMapper())) {
                this.mapper.register(model);
            }
            this.morphiaCodecProviders.add(importer.getCodecProvider(this.mapper));
        }
    }

    private Document toDocument(Object entity) {
        return DocumentWriter.encode(entity, this.getMapper(), this.getCodecRegistry());
    }

    private <T> VersionBumpInfo updateVersioning(T entity) {
        EntityModel entityModel = this.mapper.getEntityModel(entity.getClass());
        PropertyModel versionProperty = entityModel.getVersionProperty();
        if (versionProperty != null) {
            Long value = (Long)versionProperty.getValue(entity);
            long updated = value == null ? 1L : value + 1L;
            versionProperty.setValue(entity, updated);
            return new VersionBumpInfo(entity, versionProperty, value, updated);
        }
        return new VersionBumpInfo(entity);
    }

    @MorphiaInternal
    private static class VersionBumpInfo {
        private final Long oldVersion;
        private final boolean versioned;
        private final Long newVersion;
        private final PropertyModel versionProperty;
        private final Object entity;

        <T> VersionBumpInfo(T entity) {
            this.versioned = false;
            this.newVersion = null;
            this.oldVersion = null;
            this.versionProperty = null;
            this.entity = entity;
        }

        <T> VersionBumpInfo(T entity, PropertyModel versionProperty, @Nullable Long oldVersion, Long newVersion) {
            this.entity = entity;
            this.versioned = true;
            this.newVersion = newVersion;
            this.oldVersion = oldVersion;
            this.versionProperty = versionProperty;
        }

        public Object entity() {
            return this.entity;
        }

        public void filter(Document filter) {
            if (this.versioned()) {
                filter.put(this.versionProperty.getMappedName(), (Object)this.oldVersion());
            }
        }

        public <T> void filter(Query<T> query) {
            if (this.versioned() && this.newVersion() != -1L) {
                query.filter(Filters.eq(this.versionProperty.getMappedName(), this.oldVersion()));
            }
        }

        public Long newVersion() {
            return this.newVersion;
        }

        public Long oldVersion() {
            return this.oldVersion;
        }

        public void rollbackVersion() {
            if (this.entity != null && this.versionProperty != null) {
                this.versionProperty.setValue(this.entity, this.oldVersion);
            }
        }

        public boolean versioned() {
            return this.versioned;
        }
    }

    private class CollectionOperations
    extends DatastoreOperations {
        private CollectionOperations() {
        }

        @Override
        public <T> long countDocuments(MongoCollection<T> collection, Document query, CountOptions options) {
            return collection.countDocuments((Bson)query, (com.mongodb.client.model.CountOptions)options);
        }

        @Override
        public <T> DeleteResult deleteMany(MongoCollection<T> collection, Document queryDocument, DeleteOptions options) {
            return collection.deleteMany((Bson)queryDocument, (com.mongodb.client.model.DeleteOptions)options);
        }

        @Override
        public <T> DeleteResult deleteOne(MongoCollection<T> collection, Document queryDocument, DeleteOptions options) {
            return collection.deleteOne((Bson)queryDocument, (com.mongodb.client.model.DeleteOptions)options);
        }

        @Override
        public <E> FindIterable<E> find(MongoCollection<E> collection, Document query) {
            return collection.find((Bson)query);
        }

        @Override
        public <T> T findOneAndDelete(MongoCollection<T> mongoCollection, Document queryDocument, FindAndDeleteOptions options) {
            return (T)mongoCollection.findOneAndDelete((Bson)queryDocument, (FindOneAndDeleteOptions)options);
        }

        @Override
        public <T> T findOneAndUpdate(MongoCollection<T> collection, Document query, Document update, ModifyOptions options) {
            return (T)collection.findOneAndUpdate((Bson)query, (Bson)update, (FindOneAndUpdateOptions)options);
        }

        @Override
        public <T> InsertManyResult insertMany(MongoCollection<T> collection, List<T> list, InsertManyOptions options) {
            return collection.insertMany(list, options.options());
        }

        @Override
        public <T> InsertOneResult insertOne(MongoCollection<T> collection, T entity, InsertOneOptions options) {
            return collection.insertOne(entity, options.options());
        }

        @Override
        public <T> UpdateResult replaceOne(MongoCollection<T> collection, T entity, Document filter, ReplaceOptions options) {
            return collection.replaceOne((Bson)filter, entity, (com.mongodb.client.model.ReplaceOptions)options);
        }

        @Override
        public Document runCommand(Document command) {
            return DatastoreImpl.this.mongoClient.getDatabase("admin").runCommand((Bson)command);
        }

        @Override
        public <T> UpdateResult updateMany(MongoCollection<T> collection, Document queryObject, Document updateOperations, UpdateOptions options) {
            return collection.updateMany((Bson)queryObject, (Bson)updateOperations, (com.mongodb.client.model.UpdateOptions)options);
        }

        @Override
        public <T> UpdateResult updateOne(MongoCollection<T> collection, Document queryObject, Document updateOperations, UpdateOptions options) {
            return collection.updateOne((Bson)queryObject, (Bson)updateOperations, (com.mongodb.client.model.UpdateOptions)options);
        }

        @Override
        public <T> UpdateResult updateMany(MongoCollection<T> collection, Document queryObject, List<Document> updateOperations, UpdateOptions options) {
            return collection.updateMany((Bson)queryObject, updateOperations, (com.mongodb.client.model.UpdateOptions)options);
        }

        @Override
        public <T> UpdateResult updateOne(MongoCollection<T> collection, Document queryObject, List<Document> updateOperations, UpdateOptions options) {
            return collection.updateOne((Bson)queryObject, updateOperations, (com.mongodb.client.model.UpdateOptions)options);
        }
    }

    public static abstract class DatastoreOperations {
        public abstract <T> long countDocuments(MongoCollection<T> var1, Document var2, CountOptions var3);

        public abstract <T> DeleteResult deleteMany(MongoCollection<T> var1, Document var2, DeleteOptions var3);

        public abstract <T> DeleteResult deleteOne(MongoCollection<T> var1, Document var2, DeleteOptions var3);

        public abstract <E> FindIterable<E> find(MongoCollection<E> var1, Document var2);

        @Nullable
        public abstract <T> T findOneAndDelete(MongoCollection<T> var1, Document var2, FindAndDeleteOptions var3);

        @Nullable
        public abstract <T> T findOneAndUpdate(MongoCollection<T> var1, Document var2, Document var3, ModifyOptions var4);

        public abstract <T> InsertManyResult insertMany(MongoCollection<T> var1, List<T> var2, InsertManyOptions var3);

        public abstract <T> InsertOneResult insertOne(MongoCollection<T> var1, T var2, InsertOneOptions var3);

        public abstract <T> UpdateResult replaceOne(MongoCollection<T> var1, T var2, Document var3, ReplaceOptions var4);

        public abstract Document runCommand(Document var1);

        public abstract <T> UpdateResult updateMany(MongoCollection<T> var1, Document var2, Document var3, UpdateOptions var4);

        public abstract <T> UpdateResult updateMany(MongoCollection<T> var1, Document var2, List<Document> var3, UpdateOptions var4);

        public abstract <T> UpdateResult updateOne(MongoCollection<T> var1, Document var2, Document var3, UpdateOptions var4);

        public abstract <T> UpdateResult updateOne(MongoCollection<T> var1, Document var2, List<Document> var3, UpdateOptions var4);
    }

    private static class NoDeleteResult
    extends DeleteResult {
        private NoDeleteResult() {
        }

        public boolean wasAcknowledged() {
            return false;
        }

        public long getDeletedCount() {
            return 0L;
        }
    }
}

