/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia;

import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import dev.morphia.Datastore;
import dev.morphia.DatastoreImpl;
import dev.morphia.config.MapperOptionsWrapper;
import dev.morphia.config.MorphiaConfig;
import dev.morphia.mapping.MapperOptions;

public final class Morphia {
    private Morphia() {
    }

    public static Datastore createDatastore(String dbName) {
        return Morphia.createDatastore(dbName, MapperOptions.DEFAULT);
    }

    public static Datastore createDatastore(String dbName, MapperOptions options) {
        return Morphia.createDatastore(MongoClients.create((MongoClientSettings)MongoClientSettings.builder().uuidRepresentation(options.getUuidRepresentation()).build()), dbName, options);
    }

    public static Datastore createDatastore(MongoClient mongoClient, String dbName, MapperOptions options) {
        return new DatastoreImpl(mongoClient, new MapperOptionsWrapper(options, dbName));
    }

    public static Datastore createDatastore(MongoClient mongoClient, String dbName) {
        return Morphia.createDatastore(mongoClient, dbName, MapperOptions.DEFAULT);
    }

    public static Datastore createDatastore(MongoClient mongoClient) {
        return new DatastoreImpl(mongoClient, MorphiaConfig.load());
    }

    public static Datastore createDatastore(MongoClient mongoClient, MorphiaConfig config) {
        return new DatastoreImpl(mongoClient, config);
    }
}

