/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia;

import com.mongodb.WriteConcern;
import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.internal.CollectionConfigurable;
import dev.morphia.internal.WriteConfigurable;
import dev.morphia.query.filters.Filter;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

public class UpdateOptions
extends com.mongodb.client.model.UpdateOptions
implements WriteConfigurable<UpdateOptions>,
CollectionConfigurable<UpdateOptions> {
    private WriteConcern writeConcern;
    private boolean multi;
    private String collection;

    public UpdateOptions arrayFilter(Filter filter) {
        ArrayList<Document> arrayFilters = new ArrayList<Document>();
        if (this.getArrayFilters() != null) {
            arrayFilters.addAll(this.getArrayFilters());
        }
        Document filterDoc = new Document(filter.getName(), filter.getValue());
        if (filter.isNot()) {
            filterDoc = new Document("$not", (Object)filterDoc);
        }
        arrayFilters.add(new Document(filter.getField(), (Object)filterDoc));
        this.arrayFilters(arrayFilters);
        return this;
    }

    @Override
    public UpdateOptions collection(String collection) {
        this.collection = collection;
        return this;
    }

    @Override
    public String collection() {
        return this.collection;
    }

    public UpdateOptions comment(String comment) {
        super.comment(comment);
        return this;
    }

    public UpdateOptions comment(BsonValue comment) {
        super.comment(comment);
        return this;
    }

    public UpdateOptions let(Bson variables) {
        super.let(variables);
        return this;
    }

    public UpdateOptions hint(Document hint) {
        super.hint((Bson)hint);
        return this;
    }

    public UpdateOptions multi(boolean multi) {
        this.multi = multi;
        return this;
    }

    public UpdateOptions upsert(boolean upsert) {
        super.upsert(upsert);
        return this;
    }

    public UpdateOptions bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        super.bypassDocumentValidation(bypassDocumentValidation);
        return this;
    }

    public UpdateOptions collation(@Nullable Collation collation) {
        super.collation(collation);
        return this;
    }

    public UpdateOptions arrayFilters(@Nullable List<? extends Bson> arrayFilters) {
        super.arrayFilters(arrayFilters);
        return this;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public boolean isMulti() {
        return this.multi;
    }

    @MorphiaInternal
    public boolean multi() {
        return this.multi;
    }

    public UpdateOptions hint(@Nullable Bson hint) {
        super.hint(hint);
        return this;
    }

    public UpdateOptions hintString(@Nullable String hint) {
        super.hintString(hint);
        return this;
    }

    @Override
    public UpdateOptions writeConcern(@Nullable WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    @Override
    public WriteConcern writeConcern() {
        return this.writeConcern;
    }
}

