/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation;

import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.lang.Nullable;
import dev.morphia.DatastoreImpl;
import dev.morphia.aggregation.Aggregation;
import dev.morphia.aggregation.AggregationOptions;
import dev.morphia.aggregation.expressions.Expressions;
import dev.morphia.aggregation.expressions.impls.DocumentExpression;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.stages.AddFields;
import dev.morphia.aggregation.stages.AutoBucket;
import dev.morphia.aggregation.stages.Bucket;
import dev.morphia.aggregation.stages.ChangeStream;
import dev.morphia.aggregation.stages.CollectionStats;
import dev.morphia.aggregation.stages.Count;
import dev.morphia.aggregation.stages.CurrentOp;
import dev.morphia.aggregation.stages.Densify;
import dev.morphia.aggregation.stages.Documents;
import dev.morphia.aggregation.stages.Facet;
import dev.morphia.aggregation.stages.Fill;
import dev.morphia.aggregation.stages.GeoNear;
import dev.morphia.aggregation.stages.GraphLookup;
import dev.morphia.aggregation.stages.Group;
import dev.morphia.aggregation.stages.IndexStats;
import dev.morphia.aggregation.stages.Limit;
import dev.morphia.aggregation.stages.Lookup;
import dev.morphia.aggregation.stages.Match;
import dev.morphia.aggregation.stages.Merge;
import dev.morphia.aggregation.stages.Out;
import dev.morphia.aggregation.stages.PlanCacheStats;
import dev.morphia.aggregation.stages.Projection;
import dev.morphia.aggregation.stages.Redact;
import dev.morphia.aggregation.stages.ReplaceRoot;
import dev.morphia.aggregation.stages.ReplaceWith;
import dev.morphia.aggregation.stages.Sample;
import dev.morphia.aggregation.stages.Set;
import dev.morphia.aggregation.stages.SetWindowFields;
import dev.morphia.aggregation.stages.Skip;
import dev.morphia.aggregation.stages.Sort;
import dev.morphia.aggregation.stages.SortByCount;
import dev.morphia.aggregation.stages.Stage;
import dev.morphia.aggregation.stages.UnionWith;
import dev.morphia.aggregation.stages.Unset;
import dev.morphia.aggregation.stages.Unwind;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.reader.DocumentReader;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.query.filters.Filter;
import dev.morphia.query.internal.MorphiaCursor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonReader;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MorphiaInternal
public class AggregationImpl<T>
implements Aggregation<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AggregationImpl.class);
    private final DatastoreImpl datastore;
    private final Class<?> source;
    private final MongoCollection<T> collection;
    private final List<Stage> stages = new ArrayList<Stage>();

    @MorphiaInternal
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public AggregationImpl(DatastoreImpl datastore, MongoCollection<T> collection) {
        this.datastore = datastore;
        this.collection = collection;
        this.source = null;
    }

    @MorphiaInternal
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public AggregationImpl(DatastoreImpl datastore, Class<T> source, MongoCollection<T> collection) {
        this.datastore = datastore;
        this.source = source;
        this.collection = collection;
    }

    @Override
    public Aggregation<T> autoBucket(AutoBucket bucket) {
        return this.addStage(bucket);
    }

    @Override
    public Aggregation<T> bucket(Bucket bucket) {
        return this.addStage(bucket);
    }

    @Override
    public Aggregation<T> collStats(CollectionStats stats) {
        return this.addStage(stats);
    }

    @Override
    public Aggregation<T> count(String name) {
        return this.addStage(new Count(name));
    }

    @Override
    public Aggregation<T> currentOp(CurrentOp currentOp) {
        return this.addStage(currentOp);
    }

    @Override
    public Aggregation<T> densify(Densify densify) {
        return this.addStage(densify);
    }

    @Override
    public Aggregation<T> documents(DocumentExpression ... documents) {
        return this.addStage(Documents.documents(documents));
    }

    @Override
    public <R> MorphiaCursor<R> execute(Class<R> resultType) {
        MappingCursor cursor;
        List<Document> pipeline = this.pipeline();
        if (LOG.isDebugEnabled()) {
            LOG.debug("pipeline = " + pipeline);
        }
        if (this.datastore.getMapper().isMappable(resultType) && !resultType.equals(this.collection.getDocumentClass())) {
            MongoCollection collection = this.collection.withDocumentClass(Document.class);
            MongoCursor results = collection.aggregate(pipeline).iterator();
            EntityModel entityModel = this.datastore.getMapper().getEntityModel(this.collection.getDocumentClass());
            cursor = new MappingCursor((MongoCursor<Document>)results, this.datastore.getCodecRegistry().get(resultType), entityModel.getDiscriminatorKey());
        } else {
            cursor = this.collection.aggregate(pipeline, resultType).iterator();
        }
        return new MorphiaCursor(cursor);
    }

    @Override
    public <R> MorphiaCursor<R> execute(Class<R> resultType, AggregationOptions options) {
        return new MorphiaCursor(options.apply(this.pipeline(), this.datastore.getDatabase(), this.collection, resultType).iterator());
    }

    @Override
    public Aggregation<T> facet(Facet facet) {
        return this.addStage(facet);
    }

    @Override
    public Aggregation<T> fill(Fill fill) {
        return this.addStage(fill);
    }

    @Override
    public Aggregation<T> geoNear(GeoNear near) {
        return this.addStage(near);
    }

    @Override
    public Aggregation<T> graphLookup(GraphLookup lookup) {
        return this.addStage(lookup);
    }

    @Override
    public Aggregation<T> group(Group group) {
        return this.addStage(group);
    }

    @Override
    public Aggregation<T> indexStats() {
        return this.addStage(IndexStats.indexStats());
    }

    @Override
    public Aggregation<T> limit(long limit) {
        return this.addStage(Limit.limit(limit));
    }

    @Override
    public Aggregation<T> lookup(Lookup lookup) {
        return this.addStage(lookup);
    }

    @Override
    public Aggregation<T> match(Filter ... filters) {
        if (this.stages.isEmpty()) {
            Arrays.stream(filters).filter(f -> f.getName().equals("$eq")).forEach(f -> f.entityType(this.source));
        }
        return this.addStage(Match.match(filters));
    }

    @Override
    public <M> void merge(Merge<M> merge) {
        this.addStage(merge);
        this.collection.aggregate(this.pipeline()).toCollection();
    }

    @Override
    public <M> void merge(Merge<M> merge, AggregationOptions options) {
        this.addStage(merge);
        Class<M> type = merge.getType();
        type = type != null ? type : Document.class;
        options.apply(this.pipeline(), this.datastore.getDatabase(), this.collection, type).toCollection();
    }

    @Override
    public <O> void out(Out<O> out) {
        this.addStage(out);
        this.collection.aggregate(this.pipeline()).toCollection();
    }

    @Override
    public <O> void out(Out<O> out, AggregationOptions options) {
        this.addStage(out);
        Class<?> type = out.type();
        type = type != null ? type : Document.class;
        options.apply(this.pipeline(), this.datastore.getDatabase(), this.collection, type).toCollection();
    }

    @Override
    public Aggregation<T> planCacheStats() {
        return this.addStage(PlanCacheStats.planCacheStats());
    }

    @Override
    public Aggregation<T> project(Projection projection) {
        return this.addStage(projection);
    }

    @Override
    public Aggregation<T> redact(Redact redact) {
        return this.addStage(redact);
    }

    @Override
    public Aggregation<T> replaceRoot(ReplaceRoot root) {
        return this.addStage(root);
    }

    @Override
    public Aggregation<T> replaceWith(ReplaceWith with) {
        return this.addStage(with);
    }

    @Override
    public Aggregation<T> sample(long sample) {
        return this.addStage(Sample.sample(sample));
    }

    @Override
    public Aggregation<T> addFields(AddFields fields) {
        return this.addStage(fields);
    }

    @Override
    public Aggregation<T> set(Set set) {
        return this.addStage(set);
    }

    @Override
    public Aggregation<T> setWindowFields(SetWindowFields fields) {
        return this.addStage(fields);
    }

    @Override
    public Aggregation<T> skip(long skip) {
        return this.addStage(Skip.skip(skip));
    }

    @Override
    public Aggregation<T> sort(Sort sort) {
        return this.addStage(sort);
    }

    @Override
    public Aggregation<T> sortByCount(Expression sort) {
        return this.addStage(SortByCount.sortByCount(sort));
    }

    @Override
    public Aggregation<T> unionWith(Class<?> type, Stage first, Stage ... others) {
        return this.addStage(new UnionWith(type, Expressions.toList(first, others)));
    }

    @Override
    public Aggregation<T> unionWith(String collection, Stage first, Stage ... others) {
        return this.addStage(new UnionWith(collection, Expressions.toList(first, others)));
    }

    @Override
    public Aggregation<T> unset(Unset unset) {
        return this.addStage(unset);
    }

    @Override
    public Aggregation<T> unwind(Unwind unwind) {
        return this.addStage(unwind);
    }

    @Override
    public Aggregation<T> changeStream() {
        return this.addStage(ChangeStream.changeStream());
    }

    @Override
    public Aggregation<T> changeStream(ChangeStream stream) {
        return this.addStage(stream);
    }

    public List<Stage> getStages() {
        return this.stages;
    }

    public List<Document> pipeline() {
        return this.stages.stream().map(stage -> DocumentWriter.encode(stage, this.datastore.getMapper(), this.datastore.getCodecRegistry())).collect(Collectors.toList());
    }

    @Override
    public Aggregation<T> addStage(Stage stage) {
        stage.aggregation(this);
        this.stages.add(stage);
        return this;
    }

    private static class MappingCursor<R>
    implements MongoCursor<R> {
        private final MongoCursor<Document> results;
        private final Codec<R> codec;
        private final String discriminator;

        MappingCursor(MongoCursor<Document> results, Codec<R> codec, String discriminator) {
            this.results = results;
            this.codec = codec;
            this.discriminator = discriminator;
        }

        public void close() {
            this.results.close();
        }

        public boolean hasNext() {
            return this.results.hasNext();
        }

        public R next() {
            return this.map((Document)this.results.next());
        }

        public int available() {
            return this.results.available();
        }

        @Nullable
        public R tryNext() {
            return this.hasNext() ? (R)this.next() : null;
        }

        @Nullable
        public ServerCursor getServerCursor() {
            return this.results.getServerCursor();
        }

        public ServerAddress getServerAddress() {
            return this.results.getServerAddress();
        }

        private R map(Document next) {
            next.remove((Object)this.discriminator);
            return (R)this.codec.decode((BsonReader)new DocumentReader(next), DecoderContext.builder().build());
        }
    }
}

