/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.internal.CollectionConfigurable;
import dev.morphia.internal.ReadConfigurable;
import dev.morphia.internal.WriteConfigurable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;

public class AggregationOptions
implements ReadConfigurable<AggregationOptions>,
WriteConfigurable<AggregationOptions>,
CollectionConfigurable<AggregationOptions> {
    private String collection;
    private boolean allowDiskUse;
    private Integer batchSize;
    private boolean bypassDocumentValidation;
    private Collation collation;
    private Long maxTimeMS;
    private ReadPreference readPreference;
    private ReadConcern readConcern;
    private WriteConcern writeConcern;
    private Document hint;

    @Deprecated(forRemoval=true, since="2.3")
    public boolean allowDiskUse() {
        return this.allowDiskUse;
    }

    public AggregationOptions allowDiskUse(boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @MorphiaInternal
    <S, T> AggregateIterable<S> apply(List<Document> documents, MongoDatabase database, MongoCollection<T> collection, Class<S> resultType) {
        MongoCollection bound = this.prepare(collection, database);
        if (this.readConcern != null) {
            bound = bound.withReadConcern(this.readConcern);
        }
        if (this.readPreference != null) {
            bound = bound.withReadPreference(this.readPreference);
        }
        AggregateIterable aggregate = bound.aggregate(documents, resultType).allowDiskUse(Boolean.valueOf(this.allowDiskUse)).bypassDocumentValidation(Boolean.valueOf(this.bypassDocumentValidation));
        if (this.batchSize != null) {
            aggregate.batchSize(this.batchSize.intValue());
        }
        if (this.collation != null) {
            aggregate.collation(this.collation);
        }
        if (this.maxTimeMS != null) {
            aggregate.maxTime(this.maxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
        if (this.hint != null) {
            aggregate.hint((Bson)this.hint);
        }
        return aggregate;
    }

    public long maxTime(TimeUnit unit) {
        return unit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    @Deprecated(forRemoval=true, since="2.3")
    public int batchSize() {
        return this.batchSize;
    }

    public AggregationOptions batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public boolean bypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public AggregationOptions bypassDocumentValidation(boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public Collation collation() {
        return this.collation;
    }

    public AggregationOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public AggregationOptions collection(String collection) {
        this.collection = collection;
        return this;
    }

    @Override
    public String collection() {
        return this.collection;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public Document hint() {
        return this.hint;
    }

    public AggregationOptions hint(String hint) {
        this.hint = new Document("hint", (Object)hint);
        return this;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public long maxTimeMS() {
        return this.maxTimeMS;
    }

    public AggregationOptions maxTimeMS(long maxTimeMS) {
        this.maxTimeMS = maxTimeMS;
        return this;
    }

    @Override
    public ReadConcern readConcern() {
        return this.readConcern;
    }

    @Override
    public ReadPreference readPreference() {
        return this.readPreference;
    }

    @Override
    public AggregationOptions readConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
        return this;
    }

    @Override
    public AggregationOptions readPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    public String toString() {
        return "AggregationOptions{" + "allowDiskUse=" + this.allowDiskUse + ", batchSize=" + this.batchSize + ", bypassDocumentValidation=" + this.bypassDocumentValidation + ", collation=" + this.collation + ", maxTimeMS=" + this.maxTimeMS + ", readPreference=" + this.readPreference + ", readConcern=" + this.readConcern + ", writeConcern=" + this.writeConcern + ", hint=" + this.hint + '}';
    }

    @Override
    public AggregationOptions writeConcern(@Nullable WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    @Override
    @Nullable
    public WriteConcern writeConcern() {
        return this.writeConcern;
    }
}

