/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs;

import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionCodec;
import dev.morphia.aggregation.codecs.stages.AddFieldsCodec;
import dev.morphia.aggregation.codecs.stages.AutoBucketCodec;
import dev.morphia.aggregation.codecs.stages.BucketCodec;
import dev.morphia.aggregation.codecs.stages.ChangeStreamCodec;
import dev.morphia.aggregation.codecs.stages.CollectionStatsCodec;
import dev.morphia.aggregation.codecs.stages.CountCodec;
import dev.morphia.aggregation.codecs.stages.CurrentOpCodec;
import dev.morphia.aggregation.codecs.stages.DensifyCodec;
import dev.morphia.aggregation.codecs.stages.DocumentsCodec;
import dev.morphia.aggregation.codecs.stages.FacetCodec;
import dev.morphia.aggregation.codecs.stages.FillCodec;
import dev.morphia.aggregation.codecs.stages.GeoNearCodec;
import dev.morphia.aggregation.codecs.stages.GraphLookupCodec;
import dev.morphia.aggregation.codecs.stages.GroupCodec;
import dev.morphia.aggregation.codecs.stages.IndexStatsCodec;
import dev.morphia.aggregation.codecs.stages.LimitCodec;
import dev.morphia.aggregation.codecs.stages.LookupCodec;
import dev.morphia.aggregation.codecs.stages.MatchCodec;
import dev.morphia.aggregation.codecs.stages.MergeCodec;
import dev.morphia.aggregation.codecs.stages.OutCodec;
import dev.morphia.aggregation.codecs.stages.PlanCacheStatsCodec;
import dev.morphia.aggregation.codecs.stages.ProjectionCodec;
import dev.morphia.aggregation.codecs.stages.RedactCodec;
import dev.morphia.aggregation.codecs.stages.ReplaceRootCodec;
import dev.morphia.aggregation.codecs.stages.ReplaceWithCodec;
import dev.morphia.aggregation.codecs.stages.SampleCodec;
import dev.morphia.aggregation.codecs.stages.SetStageCodec;
import dev.morphia.aggregation.codecs.stages.SetWindowFieldsCodec;
import dev.morphia.aggregation.codecs.stages.SkipCodec;
import dev.morphia.aggregation.codecs.stages.SortByCountCodec;
import dev.morphia.aggregation.codecs.stages.SortCodec;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.codecs.stages.UnionWithCodec;
import dev.morphia.aggregation.codecs.stages.UnsetCodec;
import dev.morphia.aggregation.codecs.stages.UnwindCodec;
import dev.morphia.aggregation.expressions.impls.Expression;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;

public class AggregationCodecProvider
implements CodecProvider {
    private final Codec expressionCodec;
    private Map<Class, StageCodec> codecs;
    private Datastore datastore;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public AggregationCodecProvider(Datastore datastore) {
        this.datastore = datastore;
        this.expressionCodec = new ExpressionCodec(datastore);
    }

    @Nullable
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        Codec codec = this.getCodecs().get(clazz);
        if (codec == null && Expression.class.isAssignableFrom(clazz)) {
            codec = this.expressionCodec;
        }
        return codec;
    }

    private Map<Class, StageCodec> getCodecs() {
        if (this.codecs == null) {
            this.codecs = new HashMap<Class, StageCodec>();
            this.addCodec(new AddFieldsCodec(this.datastore), new AutoBucketCodec(this.datastore), new BucketCodec(this.datastore), new ChangeStreamCodec(this.datastore), new CollectionStatsCodec(this.datastore), new CountCodec(this.datastore), new CurrentOpCodec(this.datastore), new DensifyCodec(this.datastore), new DocumentsCodec(this.datastore), new FacetCodec(this.datastore), new FillCodec(this.datastore), new GeoNearCodec(this.datastore), new GraphLookupCodec(this.datastore), new GroupCodec(this.datastore), new IndexStatsCodec(this.datastore), new MergeCodec(this.datastore), new PlanCacheStatsCodec(this.datastore), new LimitCodec(this.datastore), new LookupCodec(this.datastore), new MatchCodec(this.datastore), new OutCodec(this.datastore), new ProjectionCodec(this.datastore), new RedactCodec(this.datastore), new ReplaceRootCodec(this.datastore), new ReplaceWithCodec(this.datastore), new SampleCodec(this.datastore), new SetStageCodec(this.datastore), new SetWindowFieldsCodec(this.datastore), new SkipCodec(this.datastore), new SortCodec(this.datastore), new SortByCountCodec(this.datastore), new UnionWithCodec(this.datastore), new UnsetCodec(this.datastore), new UnwindCodec(this.datastore));
        }
        return this.codecs;
    }

    @Nullable
    private void addCodec(StageCodec ... stageCodecs) {
        for (StageCodec codec : stageCodecs) {
            this.codecs.put(codec.getEncoderClass(), codec);
        }
    }
}

