/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.expressions.impls.DocumentExpression;
import dev.morphia.aggregation.stages.AutoBucket;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class AutoBucketCodec
extends StageCodec<AutoBucket> {
    public AutoBucketCodec(Datastore datastore) {
        super(datastore);
    }

    public Class getEncoderClass() {
        return AutoBucket.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, AutoBucket value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            ExpressionHelper.expression(this.getDatastore(), writer, "groupBy", value.getGroupBy(), encoderContext);
            ExpressionHelper.expression(this.getDatastore(), writer, "buckets", value.getBuckets(), encoderContext);
            ExpressionHelper.expression(this.getDatastore(), writer, "granularity", value.getGranularity(), encoderContext);
            DocumentExpression output = value.getOutput();
            if (output != null) {
                output.encode("output", this.getDatastore(), writer, encoderContext);
            }
        });
    }
}

