/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.expressions.impls.DocumentExpression;
import dev.morphia.aggregation.stages.Bucket;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class BucketCodec
extends StageCodec<Bucket> {
    public BucketCodec(Datastore datastore) {
        super(datastore);
    }

    public Class getEncoderClass() {
        return Bucket.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, Bucket value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            ExpressionHelper.expression(this.getDatastore(), writer, "groupBy", value.getGroupBy(), encoderContext);
            ExpressionHelper.expression(this.getDatastore(), writer, "boundaries", value.getBoundaries(), encoderContext);
            ExpressionHelper.value(this.getDatastore(), writer, "default", value.getDefaultValue(), encoderContext);
            DocumentExpression output = value.getOutput();
            if (output != null) {
                output.encode("output", this.getDatastore(), writer, encoderContext);
            }
        });
    }
}

