/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.FullDocumentBeforeChange;
import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.stages.ChangeStream;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class ChangeStreamCodec
extends StageCodec<ChangeStream> {
    public ChangeStreamCodec(Datastore datastore) {
        super(datastore);
    }

    public Class<ChangeStream> getEncoderClass() {
        return ChangeStream.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, ChangeStream changeStream, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            FullDocumentBeforeChange beforeChange;
            ExpressionHelper.value(writer, "allChangesForCluster", changeStream.allChangesForCluster());
            FullDocument fullDocument = changeStream.fullDocument();
            if (fullDocument != FullDocument.DEFAULT) {
                ExpressionHelper.value(this.getDatastore(), writer, "fullDocument", fullDocument.getValue(), encoderContext);
            }
            if ((beforeChange = changeStream.fullDocumentBeforeChange()) != FullDocumentBeforeChange.DEFAULT) {
                ExpressionHelper.value(this.getDatastore(), writer, "fullDocumentBeforeChange", beforeChange.getValue(), encoderContext);
            }
            if (changeStream.resumeAfter() != null) {
                ExpressionHelper.value(this.getDatastore(), writer, "resumeAfter", changeStream.resumeAfter(), encoderContext);
            }
            if (changeStream.startAfter() != null) {
                ExpressionHelper.value(this.getDatastore(), writer, "startAfter", changeStream.startAfter(), encoderContext);
            }
            if (changeStream.startAtOperationTime() != null) {
                ExpressionHelper.value(this.getDatastore(), writer, "startAtOperationTime", changeStream.startAtOperationTime(), encoderContext);
            }
        });
    }
}

