/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.stages.CollectionStats;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class CollectionStatsCodec
extends StageCodec<CollectionStats> {
    public CollectionStatsCodec(Datastore datastore) {
        super(datastore);
    }

    public Class<CollectionStats> getEncoderClass() {
        return CollectionStats.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, CollectionStats value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            if (value.getHistogram()) {
                ExpressionHelper.document(writer, "latencyStats", () -> writer.writeBoolean("histograms", true));
            }
            if (value.getScale() != null) {
                ExpressionHelper.document(writer, "storageStats", () -> writer.writeInt32("scale", value.getScale().intValue()));
            }
            if (value.getCount()) {
                ExpressionHelper.document(writer, "count", () -> {});
            }
        });
    }
}

