/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.stages.Densify;
import java.util.List;
import java.util.Locale;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class DensifyCodec
extends StageCodec<Densify> {
    public DensifyCodec(Datastore datastore) {
        super(datastore);
    }

    public Class<Densify> getEncoderClass() {
        return Densify.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, Densify value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            ExpressionHelper.value(this.getDatastore(), writer, "field", value.field(), encoderContext);
            ExpressionHelper.document(writer, "range", () -> {
                Densify.Range range = value.range();
                ExpressionHelper.value(this.getDatastore(), writer, "step", range.step(), encoderContext);
                ExpressionHelper.value(this.getDatastore(), writer, "unit", range.unit().name().toLowerCase(Locale.ROOT), encoderContext);
                switch (range.type()) {
                    case BOUNDED: {
                        ExpressionHelper.value(this.getDatastore(), writer, "bounds", List.of(range.lowerBound(), range.upperBound()), encoderContext);
                        break;
                    }
                    case FULL: 
                    case PARTITION: {
                        ExpressionHelper.value(this.getDatastore(), writer, "bounds", range.type().name().toLowerCase(Locale.ROOT), encoderContext);
                    }
                }
            });
        });
    }
}

