/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.stages.Facet;
import dev.morphia.aggregation.stages.Stage;
import java.util.List;
import java.util.Map;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;

public class FacetCodec
extends StageCodec<Facet> {
    public FacetCodec(Datastore datastore) {
        super(datastore);
    }

    public Class<Facet> getEncoderClass() {
        return Facet.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, Facet value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            for (Map.Entry<String, List<Stage>> entry : value.getFields().entrySet()) {
                ExpressionHelper.array(writer, entry.getKey(), () -> {
                    List stages = (List)entry.getValue();
                    for (Stage stage : stages) {
                        Codec codec = this.getCodecRegistry().get(stage.getClass());
                        codec.encode(writer, (Object)stage, encoderContext);
                    }
                });
            }
        });
    }
}

