/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.stages.Fill;
import dev.morphia.query.Sort;
import java.util.List;
import java.util.Locale;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class FillCodec
extends StageCodec<Fill> {
    public FillCodec(Datastore datastore) {
        super(datastore);
    }

    public Class<Fill> getEncoderClass() {
        return Fill.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, Fill fill, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            Sort[] sorts;
            List<String> partitionByFields;
            if (fill.partitionBy() != null) {
                ExpressionHelper.expression(this.getDatastore(), writer, "partitionBy", fill.partitionBy(), encoderContext);
            }
            if ((partitionByFields = fill.partitionByFields()) != null) {
                ExpressionHelper.array(writer, "partitionByFields", () -> partitionByFields.forEach(arg_0 -> ((BsonWriter)writer).writeString(arg_0)));
            }
            if ((sorts = fill.sortBy()) != null) {
                ExpressionHelper.document(writer, "sortBy", () -> {
                    for (Sort sort : sorts) {
                        writer.writeInt64(sort.getField(), (long)sort.getOrder());
                    }
                });
            }
            ExpressionHelper.document(writer, "output", () -> fill.fields().forEach((key, value) -> {
                if (value instanceof Expression) {
                    ExpressionHelper.document(writer, key, () -> ExpressionHelper.expression(this.getDatastore(), writer, "value", (Expression)value, encoderContext));
                } else if (value instanceof Fill.Method) {
                    ExpressionHelper.document(writer, key, () -> ExpressionHelper.value(writer, "method", ((Fill.Method)((Object)((Object)((Object)((Object)((Object)value)))))).name().toLowerCase(Locale.ROOT)));
                }
            }));
        });
    }
}

