/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.stages.GeoNear;
import dev.morphia.query.filters.Filter;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class GeoNearCodec
extends StageCodec<GeoNear> {
    public GeoNearCodec(Datastore datastore) {
        super(datastore);
    }

    public Class<GeoNear> getEncoderClass() {
        return GeoNear.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, GeoNear value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            ExpressionHelper.value(this.getDatastore(), writer, "near", value.getPoint(), encoderContext);
            ExpressionHelper.value(this.getDatastore(), writer, "near", value.getCoordinates(), encoderContext);
            ExpressionHelper.value(writer, "key", value.getKey());
            ExpressionHelper.value(writer, "distanceField", value.getDistanceField());
            ExpressionHelper.value(writer, "spherical", value.getSpherical());
            ExpressionHelper.value(this.getDatastore(), writer, "maxDistance", value.getMaxDistance(), encoderContext);
            ExpressionHelper.value(this.getDatastore(), writer, "minDistance", value.getMinDistance(), encoderContext);
            Filter[] filters = value.getFilters();
            if (filters != null) {
                ExpressionHelper.document(writer, "query", () -> {
                    for (Filter filter : filters) {
                        filter.encode(this.getDatastore(), writer, encoderContext);
                    }
                });
            }
            ExpressionHelper.value(this.getDatastore(), writer, "distanceMultiplier", value.getDistanceMultiplier(), encoderContext);
            ExpressionHelper.value(writer, "includeLocs", value.getIncludeLocs());
        });
    }
}

