/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.stages.GraphLookup;
import dev.morphia.query.filters.Filter;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class GraphLookupCodec
extends StageCodec<GraphLookup> {
    public GraphLookupCodec(Datastore datastore) {
        super(datastore);
    }

    public Class<GraphLookup> getEncoderClass() {
        return GraphLookup.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, GraphLookup value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            if (value.getFrom() != null) {
                ExpressionHelper.value(writer, "from", value.getFrom());
            } else {
                writer.writeString("from", this.getDatastore().getMapper().getEntityModel(value.getFromType()).getCollectionName());
            }
            ExpressionHelper.expression(this.getDatastore(), writer, "startWith", value.getStartWith(), encoderContext);
            ExpressionHelper.value(writer, "connectFromField", value.getConnectFromField());
            ExpressionHelper.value(writer, "connectToField", value.getConnectToField());
            ExpressionHelper.value(writer, "as", value.getAs());
            ExpressionHelper.value(writer, "maxDepth", value.getMaxDepth());
            ExpressionHelper.value(writer, "depthField", value.getDepthField());
            Filter[] restriction = value.getRestriction();
            if (restriction != null) {
                ExpressionHelper.document(writer, "restrictSearchWithMatch", () -> {
                    for (Filter filter : restriction) {
                        filter.encode(this.getDatastore(), writer, encoderContext);
                    }
                });
            }
        });
    }
}

