/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.expressions.impls.Fields;
import dev.morphia.aggregation.stages.Group;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class GroupCodec
extends StageCodec<Group> {
    public GroupCodec(Datastore datastore) {
        super(datastore);
    }

    public Class<Group> getEncoderClass() {
        return Group.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, Group group, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            Group.GroupId id = group.getId();
            if (id != null) {
                writer.writeName("_id");
                if (id.getDocument() != null) {
                    id.getDocument().encode(this.getDatastore(), writer, encoderContext);
                } else if (id.getField() != null) {
                    ExpressionHelper.wrapExpression(this.getDatastore(), writer, id.getField(), encoderContext);
                }
            } else {
                writer.writeNull("_id");
            }
            Fields<Group> fields = group.getFields();
            if (fields != null) {
                fields.encode(this.getDatastore(), writer, encoderContext);
            }
        });
    }
}

