/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.stages.Lookup;
import dev.morphia.aggregation.stages.Stage;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;

public class LookupCodec
extends StageCodec<Lookup> {
    public LookupCodec(Datastore datastore) {
        super(datastore);
    }

    public Class<Lookup> getEncoderClass() {
        return Lookup.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, Lookup value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            if (value.getFrom() != null) {
                writer.writeString("from", value.getFrom());
            } else if (value.getFromType() != null) {
                writer.writeString("from", this.getDatastore().getMapper().getEntityModel(value.getFromType()).getCollectionName());
            }
            if (value.getLocalField() != null) {
                writer.writeString("localField", value.getLocalField());
            }
            if (value.getForeignField() != null) {
                writer.writeString("foreignField", value.getForeignField());
            }
            writer.writeString("as", value.getAs());
            List<Stage> pipeline = value.getPipeline();
            if (pipeline != null) {
                ExpressionHelper.expression(this.getDatastore(), writer, "let", value.getVariables(), encoderContext);
                ExpressionHelper.array(writer, "pipeline", () -> {
                    for (Stage stage : pipeline) {
                        Codec codec = this.getCodecRegistry().get(stage.getClass());
                        codec.encode(writer, (Object)stage, encoderContext);
                    }
                });
            }
        });
    }
}

