/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.stages.Merge;
import java.util.List;
import java.util.Map;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class MergeCodec
extends StageCodec<Merge> {
    public MergeCodec(Datastore datastore) {
        super(datastore);
    }

    public Class<Merge> getEncoderClass() {
        return Merge.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, Merge merge, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            Map<String, Expression> variables;
            String collection = merge.getType() != null ? this.getDatastore().getMapper().getEntityModel(merge.getType()).getCollectionName() : merge.getCollection();
            String database = merge.getDatabase();
            if (database == null) {
                writer.writeString("into", collection);
            } else {
                ExpressionHelper.document(writer, "into", () -> {
                    writer.writeString("db", database);
                    writer.writeString("coll", collection);
                });
            }
            List<String> on = merge.getOn();
            if (on != null) {
                if (on.size() == 1) {
                    writer.writeString("on", on.get(0));
                } else {
                    ExpressionHelper.array(writer, "on", () -> on.forEach(arg_0 -> ((BsonWriter)writer).writeString(arg_0)));
                }
            }
            if ((variables = merge.getVariables()) != null) {
                ExpressionHelper.document(writer, "let", () -> {
                    for (Map.Entry entry : variables.entrySet()) {
                        ExpressionHelper.expression(this.getDatastore(), writer, (String)entry.getKey(), (Expression)entry.getValue(), encoderContext);
                    }
                });
            }
            this.writeEnum(writer, "whenMatched", (Enum<?>)merge.getWhenMatched());
            ExpressionHelper.value(this.getDatastore(), writer, "whenMatched", merge.getWhenMatchedPipeline(), encoderContext);
            this.writeEnum(writer, "whenNotMatched", (Enum<?>)merge.getWhenNotMatched());
        });
    }

    private void writeEnum(BsonWriter writer, String name, Enum<?> value) {
        if (value != null) {
            writer.writeString(name, value.name().toLowerCase());
        }
    }
}

