/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.stages.Out;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class OutCodec
extends StageCodec<Out> {
    public OutCodec(Datastore datastore) {
        super(datastore);
    }

    public Class<Out> getEncoderClass() {
        return Out.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, Out value, EncoderContext encoderContext) {
        Class<?> type = value.type();
        String collectionName = type != null ? this.getDatastore().getMapper().getEntityModel(type).getCollectionName() : value.collection();
        if (value.database() == null) {
            writer.writeString(collectionName);
        } else {
            ExpressionHelper.document(writer, () -> {
                writer.writeString("db", value.database());
                writer.writeString("coll", collectionName);
            });
        }
    }
}

