/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.codecs.stages.StageCodec;
import dev.morphia.aggregation.expressions.TimeUnit;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.stages.SetWindowFields;
import dev.morphia.query.Sort;
import java.util.List;
import java.util.Locale;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;

public class SetWindowFieldsCodec
extends StageCodec<SetWindowFields> {
    private Codec<Object> objectCodec;

    public SetWindowFieldsCodec(Datastore datastore) {
        super(datastore);
    }

    public Codec<Object> getObjectCodec() {
        if (this.objectCodec == null) {
            this.objectCodec = this.getDatastore().getCodecRegistry().get(Object.class);
        }
        return this.objectCodec;
    }

    public Class<SetWindowFields> getEncoderClass() {
        return SetWindowFields.class;
    }

    @Override
    protected void encodeStage(BsonWriter writer, SetWindowFields value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            Sort[] sorts;
            if (value.partition() != null) {
                writer.writeName("partitionBy");
                ExpressionHelper.expression(this.getDatastore(), writer, value.partition(), encoderContext);
            }
            if ((sorts = value.sorts()) != null) {
                ExpressionHelper.document(writer, "sortBy", () -> {
                    for (Sort sort : sorts) {
                        writer.writeInt64(sort.getField(), (long)sort.getOrder());
                    }
                });
            }
            ExpressionHelper.document(writer, "output", () -> {
                for (SetWindowFields.Output output : value.outputs()) {
                    ExpressionHelper.document(writer, output.name(), () -> {
                        this.operator(writer, encoderContext, output.operator());
                        this.window(writer, output, encoderContext);
                    });
                }
            });
        });
    }

    private void documents(BsonWriter writer, @Nullable List<Object> list, String documents, EncoderContext encoderContext) {
        if (list != null) {
            ExpressionHelper.array(writer, documents, () -> {
                for (Object document : list) {
                    this.getObjectCodec().encode(writer, document, encoderContext);
                }
            });
        }
    }

    private void operator(BsonWriter writer, EncoderContext encoderContext, @Nullable Expression operator) {
        if (operator != null) {
            ExpressionHelper.expression(this.getDatastore(), writer, operator, encoderContext);
        }
    }

    private void window(BsonWriter writer, SetWindowFields.Output output, EncoderContext encoderContext) {
        SetWindowFields.Window window = output.windowDef();
        if (window != null) {
            ExpressionHelper.document(writer, "window", () -> {
                this.documents(writer, window.documents(), "documents", encoderContext);
                this.documents(writer, window.range(), "range", encoderContext);
                TimeUnit unit = window.unit();
                if (unit != null) {
                    writer.writeString("unit", unit.name().toLowerCase(Locale.ROOT));
                }
            });
        }
    }
}

