/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.codecs.stages;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.stages.Stage;
import dev.morphia.sofia.Sofia;
import java.util.Locale;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public abstract class StageCodec<T extends Stage>
implements Codec<T> {
    private Datastore datastore;

    protected StageCodec(Datastore datastore) {
        this.datastore = datastore;
    }

    public final T decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException(Sofia.encodingOnly(new Locale[0]));
    }

    public final void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            writer.writeName(value.stageName());
            this.encodeStage(writer, value, encoderContext);
        });
    }

    protected abstract void encodeStage(BsonWriter var1, T var2, EncoderContext var3);

    public Datastore getDatastore() {
        return this.datastore;
    }

    protected CodecRegistry getCodecRegistry() {
        return this.getDatastore().getCodecRegistry();
    }
}

