/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions;

import dev.morphia.aggregation.expressions.WindowExpressions;
import dev.morphia.aggregation.expressions.impls.Accumulator;
import dev.morphia.aggregation.expressions.impls.AccumulatorExpression;
import dev.morphia.aggregation.expressions.impls.EndResultsExpression;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.FunctionExpression;
import dev.morphia.aggregation.expressions.impls.NRankedResultsExpression;
import dev.morphia.aggregation.expressions.impls.Push;
import dev.morphia.aggregation.expressions.impls.RankedResultsExpression;
import dev.morphia.query.Sort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class AccumulatorExpressions {
    private AccumulatorExpressions() {
    }

    public static AccumulatorExpression accumulator(String initFunction, String accumulateFunction, List<Expression> accumulateArgs, String mergeFunction) {
        return new AccumulatorExpression(initFunction, accumulateFunction, accumulateArgs, mergeFunction);
    }

    public static Expression addToSet(Expression value) {
        return new Expression("$addToSet", value);
    }

    public static Expression avg(Expression value, Expression ... additional) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(value);
        expressions.addAll(Arrays.asList(additional));
        return new Accumulator("$avg", expressions);
    }

    public static Expression bottom(Expression output, Sort ... sortBy) {
        return new RankedResultsExpression("$bottom", output, sortBy);
    }

    public static Expression bottomN(Expression n, Expression output, Sort ... sortBy) {
        return new NRankedResultsExpression("$bottomN", n, output, sortBy);
    }

    public static Expression first(Expression value) {
        return new Expression("$first", value);
    }

    public static Expression firstN(Expression n, Expression input) {
        return new EndResultsExpression("$firstN", n, input);
    }

    public static Expression function(String body, Expression ... args) {
        return new FunctionExpression(body, Arrays.asList(args));
    }

    public static Expression last(Expression value) {
        return new Expression("$last", value);
    }

    public static Expression lastN(Expression n, Expression input) {
        return new EndResultsExpression("$lastN", n, input);
    }

    public static Expression max(Expression value) {
        return new Expression("$max", value);
    }

    public static Expression maxN(Expression n, Expression input) {
        return new EndResultsExpression("$maxN", n, input);
    }

    public static Expression min(Expression value) {
        return new Expression("$min", value);
    }

    public static Expression minN(Expression n, Expression input) {
        return new EndResultsExpression("$minN", n, input);
    }

    public static Expression push(Expression value) {
        return new Expression("$push", value);
    }

    public static Push push() {
        return new Push();
    }

    public static Expression sum(Expression first, Expression ... additional) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(first);
        expressions.addAll(Arrays.asList(additional));
        return new Accumulator("$sum", expressions);
    }

    public static Expression top(Expression output, Sort ... sortBy) {
        return new RankedResultsExpression("$top", output, sortBy);
    }

    public static Expression topN(Expression n, Expression output, Sort ... sortBy) {
        return new NRankedResultsExpression("$topN", n, output, sortBy);
    }

    @Deprecated
    public static Expression stdDevPop(Expression value, Expression ... additional) {
        return WindowExpressions.stdDevPop(value, additional);
    }

    @Deprecated
    public static Expression stdDevSamp(Expression value, Expression ... additional) {
        return WindowExpressions.stdDevSamp(value, additional);
    }
}

