/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.ArrayExpression;
import dev.morphia.aggregation.expressions.impls.ArrayFilterExpression;
import dev.morphia.aggregation.expressions.impls.ArrayIndexExpression;
import dev.morphia.aggregation.expressions.impls.ArrayLiteral;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.MapExpression;
import dev.morphia.aggregation.expressions.impls.RangeExpression;
import dev.morphia.aggregation.expressions.impls.ReduceExpression;
import dev.morphia.aggregation.expressions.impls.SliceExpression;
import dev.morphia.aggregation.expressions.impls.ZipExpression;
import dev.morphia.annotations.internal.MorphiaExperimental;
import dev.morphia.query.Sort;
import dev.morphia.sofia.Sofia;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public final class ArrayExpressions {
    private ArrayExpressions() {
    }

    public static ArrayExpression array(Expression ... expressions) {
        return new ArrayLiteral(expressions);
    }

    @MorphiaExperimental
    public static ArrayExpression array(Object ... objects) {
        return new ArrayLiteral(objects);
    }

    public static Expression arrayToObject(Expression array) {
        return new Expression("$arrayToObject", array);
    }

    public static Expression concatArrays(Expression array, Expression additional) {
        return new Expression("$concatArrays", Arrays.asList(array, additional));
    }

    public static Expression elementAt(Expression array, Expression index) {
        return new Expression("$arrayElemAt", List.of(array, index));
    }

    public static ArrayFilterExpression filter(Expression array, Expression conditional) {
        return new ArrayFilterExpression(array, conditional);
    }

    public static Expression in(Expression search, Expression array) {
        return new Expression("$in", List.of(search, array));
    }

    public static Expression indexOfArray(Expression array, Expression search) {
        return new ArrayIndexExpression(array, search);
    }

    public static Expression isArray(Expression array) {
        return new Expression("$isArray", List.of(array));
    }

    public static MapExpression map(Expression input, Expression in) {
        return new MapExpression(input, in);
    }

    public static Expression objectToArray(Expression array) {
        return new Expression("$objectToArray", array);
    }

    public static RangeExpression range(int start, int end) {
        return new RangeExpression(start, end);
    }

    public static Expression reduce(Expression input, Expression initial, Expression in) {
        return new ReduceExpression(input, initial, in);
    }

    public static Expression reverseArray(Expression array) {
        return new Expression("$reverseArray", array);
    }

    public static Expression size(Expression array) {
        return new Expression("$size", array);
    }

    public static Expression slice(Expression array, int size) {
        return new SliceExpression(array, size);
    }

    public static Expression sortArray(final Expression input, final Sort ... sort) {
        if (sort.length == 0) {
            throw new IllegalArgumentException(Sofia.atLeastOneSortRequired(new Locale[0]));
        }
        return new Expression("$sortArray"){

            @Override
            public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
                ExpressionHelper.document(writer, this.getOperation(), () -> {
                    ExpressionHelper.expression(datastore, writer, "input", input, encoderContext);
                    if (sort[0].getField().equals("$natural")) {
                        ExpressionHelper.value(writer, "sortBy", sort[0].getOrder());
                    } else {
                        ExpressionHelper.document(writer, "sortBy", () -> {
                            for (Sort s : sort) {
                                writer.writeInt64(s.getField(), (long)s.getOrder());
                            }
                        });
                    }
                });
            }
        };
    }

    public static ZipExpression zip(Expression ... arrays) {
        return new ZipExpression(Arrays.asList(arrays));
    }
}

