/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions;

import com.mongodb.lang.NonNull;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.ExpressionList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class BooleanExpressions {
    private BooleanExpressions() {
    }

    public static LogicalExpression and(Expression first, Expression ... additional) {
        return new LogicalExpression("$and", ExpressionList.coalesce(first, additional));
    }

    public static LogicalExpression and() {
        return new LogicalExpression("$and");
    }

    public static Expression not(Expression value) {
        return new Expression("$not", new ExpressionList(value));
    }

    public static LogicalExpression or(Expression first, Expression ... additional) {
        return new LogicalExpression("$or", ExpressionList.coalesce(first, additional));
    }

    public static LogicalExpression or() {
        return new LogicalExpression("$or");
    }

    public static class LogicalExpression
    extends Expression {
        private LogicalExpression(String operation) {
            super(operation, new ExpressionList(new Expression[0]));
        }

        private LogicalExpression(String operation, @NonNull ExpressionList list) {
            super(operation, list);
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public LogicalExpression add(Expression expression) {
            ((ExpressionList)this.getValue()).add(expression);
            return this;
        }
    }
}

