/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions;

import com.mongodb.lang.Nullable;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.ExpressionList;
import java.util.Arrays;
import java.util.List;

public final class ComparisonExpressions {
    private ComparisonExpressions() {
    }

    public static Expression cmp(Expression first, Expression second) {
        return new Expression("$cmp", List.of(first, second));
    }

    public static Expression eq(Expression first, @Nullable Expression second) {
        return new Expression("$eq", Arrays.asList(first, second));
    }

    public static Expression gt(Expression first, Expression second) {
        return new Expression("$gt", new ExpressionList(first, second));
    }

    public static Expression gte(Expression first, Expression second) {
        return new Expression("$gte", List.of(first, second));
    }

    public static Expression lt(Expression first, Expression second) {
        return new Expression("$lt", List.of(first, second));
    }

    public static Expression lte(Expression first, Expression second) {
        return new Expression("$lte", List.of(first, second));
    }

    public static Expression ne(Expression first, @Nullable Expression second) {
        return new Expression("$ne", Arrays.asList(first, second));
    }
}

