/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.TimeUnit;
import dev.morphia.aggregation.expressions.impls.DateDeltaExpression;
import dev.morphia.aggregation.expressions.impls.DateDiffExpression;
import dev.morphia.aggregation.expressions.impls.DateFromParts;
import dev.morphia.aggregation.expressions.impls.DateFromString;
import dev.morphia.aggregation.expressions.impls.DateToParts;
import dev.morphia.aggregation.expressions.impls.DateToString;
import dev.morphia.aggregation.expressions.impls.DateTruncExpression;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.IsoDates;
import dev.morphia.annotations.internal.MorphiaInternal;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public final class DateExpressions {
    private DateExpressions() {
    }

    public static DateDeltaExpression dateAdd(Expression startDate, long amount, TimeUnit unit) {
        return new DateDeltaExpression("$dateAdd", startDate, amount, unit);
    }

    public static DateDiffExpression dateDiff(Expression startDate, Expression endDate, TimeUnit unit) {
        return new DateDiffExpression(startDate, endDate, unit);
    }

    public static DateFromParts dateFromParts() {
        return new DateFromParts();
    }

    public static DateFromString dateFromString() {
        return new DateFromString();
    }

    public static DateDeltaExpression dateSubtract(Expression startDate, long amount, TimeUnit unit) {
        return new DateDeltaExpression("$dateSubtract", startDate, amount, unit);
    }

    public static DateToParts dateToParts(Expression date) {
        return new DateToParts(date);
    }

    public static DateToString dateToString() {
        return new DateToString();
    }

    public static DateTruncExpression dateTrunc(Expression date, TimeUnit unit) {
        return new DateTruncExpression(date, unit);
    }

    public static DateExpression dayOfMonth(Expression value) {
        return new DateExpression("$dayOfMonth", value);
    }

    public static DateExpression dayOfWeek(Expression value) {
        return new DateExpression("$dayOfWeek", value);
    }

    public static DateExpression dayOfYear(Expression value) {
        return new DateExpression("$dayOfYear", value);
    }

    public static DateExpression hour(Expression value) {
        return new DateExpression("$hour", value);
    }

    public static IsoDates isoDayOfWeek(Expression value) {
        return new IsoDates("$isoDayOfWeek", value);
    }

    public static IsoDates isoWeek(Expression value) {
        return new IsoDates("$isoWeek", value);
    }

    public static IsoDates isoWeekYear(Expression value) {
        return new IsoDates("$isoWeekYear", value);
    }

    public static DateExpression milliseconds(Expression value) {
        return new DateExpression("$millisecond", value);
    }

    public static DateExpression minute(Expression value) {
        return new DateExpression("$minute", value);
    }

    public static DateExpression month(Expression value) {
        return new DateExpression("$month", value);
    }

    public static DateExpression second(Expression value) {
        return new DateExpression("$second", value);
    }

    public static DateExpression toDate(Expression value) {
        return new DateExpression("$toDate", value);
    }

    public static Expression tsIncrement(Expression expression) {
        return new Expression("$tsIncrement", expression);
    }

    public static Expression tsSecond(Expression expression) {
        return new Expression("$tsSecond", expression);
    }

    public static DateExpression week(Expression value) {
        return new DateExpression("$week", value);
    }

    public static DateExpression year(Expression value) {
        return new DateExpression("$year", value);
    }

    public static class DateExpression
    extends Expression {
        protected DateExpression(String operation, Expression value) {
            super(operation, value);
        }

        @Override
        @MorphiaInternal
        public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
            ExpressionHelper.expression(datastore, writer, this.getOperation(), this.getValue(), encoderContext);
        }
    }
}

