/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions;

import com.mongodb.lang.Nullable;
import dev.morphia.aggregation.expressions.impls.DocumentExpression;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.LiteralExpression;
import dev.morphia.aggregation.expressions.impls.MetaExpression;
import dev.morphia.aggregation.expressions.impls.ValueExpression;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Expressions {
    private Expressions() {
    }

    public static DocumentExpression document() {
        return new DocumentExpression();
    }

    public static DocumentExpression document(String name, Expression expression) {
        return new DocumentExpression().field(name, expression);
    }

    public static Expression field(String name) {
        return new ValueExpression(name.startsWith("$") ? name : "$" + name);
    }

    public static Expression literal(Object value) {
        return new LiteralExpression(value);
    }

    public static Expression meta() {
        return new MetaExpression();
    }

    @Deprecated(forRemoval=true, since="2.3")
    public static DocumentExpression of() {
        return new DocumentExpression();
    }

    @MorphiaInternal
    public static <T> List<T> toList(T first, T ... additional) {
        ArrayList<T> expressions = new ArrayList<T>();
        expressions.add(first);
        expressions.addAll(Arrays.asList(additional));
        return expressions;
    }

    public static ValueExpression value(@Nullable Object value) {
        return new ValueExpression(value);
    }
}

