/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions;

import dev.morphia.Datastore;
import dev.morphia.aggregation.expressions.impls.DocumentExpression;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.SetFieldExpression;
import dev.morphia.aggregation.expressions.impls.UnsetFieldExpression;
import dev.morphia.aggregation.expressions.impls.ValueExpression;
import dev.morphia.query.filters.Filter;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public final class Miscellaneous {
    private Miscellaneous() {
    }

    public static Expression getField(String field) {
        return Miscellaneous.getField(new ValueExpression((Object)field));
    }

    public static Expression getField(Expression field) {
        return new Expression("$getField", field);
    }

    public static Expression rand() {
        return new Expression("$rand", new DocumentExpression());
    }

    public static Filter sampleRate(double rate) {
        return new Filter("$sampleRate", null, rate){

            @Override
            public void encode(Datastore datastore, BsonWriter writer, EncoderContext context) {
                this.writeNamedValue(this.getName(), this.getValue(), datastore, writer, context);
            }
        };
    }

    public static Expression setField(String field, Object input, Expression value) {
        return Miscellaneous.setField(new ValueExpression((Object)field), input, value);
    }

    public static Expression setField(Expression field, Object input, Expression value) {
        return new SetFieldExpression(field, input, value);
    }

    public static Expression unsetField(String field, Object input) {
        return Miscellaneous.unsetField(new ValueExpression((Object)field), input);
    }

    public static Expression unsetField(Expression field, Object input) {
        return new UnsetFieldExpression(field, input);
    }
}

