/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Accumulator;
import dev.morphia.aggregation.expressions.impls.CalculusExpression;
import dev.morphia.aggregation.expressions.impls.ExpMovingAvg;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.MathExpression;
import dev.morphia.aggregation.expressions.impls.ShiftExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public final class WindowExpressions {
    private WindowExpressions() {
    }

    public static Expression covariancePop(Expression first, Expression second) {
        return new MathExpression("$covariancePop", List.of(first, second));
    }

    public static Expression covarianceSamp(Expression first, Expression second) {
        return new MathExpression("$covarianceSamp", List.of(first, second));
    }

    public static Expression denseRank() {
        return new Expression("$denseRank"){

            @Override
            public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
                ExpressionHelper.document(writer, this.getOperation(), () -> {});
            }
        };
    }

    public static CalculusExpression derivative(Expression input) {
        return new CalculusExpression("$derivative", input);
    }

    public static Expression documentNumber() {
        return new Expression("$documentNumber"){

            @Override
            public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
                ExpressionHelper.document(writer, this.getOperation(), () -> {});
            }
        };
    }

    public static Expression expMovingAvg(Expression input, int n) {
        return new ExpMovingAvg(input, n);
    }

    public static CalculusExpression integral(Expression input) {
        return new CalculusExpression("$integral", input);
    }

    public static Expression linearFill(Expression fillValue) {
        return new Expression("$linearFill", fillValue);
    }

    public static Expression locf(Expression fillValue) {
        return new Expression("$locf", fillValue);
    }

    public static Expression rank() {
        return new Expression("$rank"){

            @Override
            public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
                ExpressionHelper.document(writer, this.getOperation(), () -> {});
            }
        };
    }

    public static ShiftExpression shift(Expression output, long by, Expression defaultValue) {
        return new ShiftExpression(output, by, defaultValue);
    }

    public static Expression stdDevPop(Expression value, Expression ... additional) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(value);
        expressions.addAll(Arrays.asList(additional));
        return new Accumulator("$stdDevPop", expressions);
    }

    public static Expression stdDevSamp(Expression value, Expression ... additional) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(value);
        expressions.addAll(Arrays.asList(additional));
        return new Accumulator("$stdDevSamp", expressions);
    }
}

