/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.aggregation.expressions.impls.ExpressionList;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class Accumulator
extends Expression {
    @MorphiaInternal
    public Accumulator(String operation, List<Expression> values) {
        super(operation, new ExpressionList(values));
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        writer.writeName(this.getOperation());
        ExpressionList values = this.getValue();
        if (values != null) {
            List<Expression> list = values.getValues();
            if (list.size() > 1) {
                writer.writeStartArray();
            }
            for (Expression expression : list) {
                ExpressionHelper.wrapExpression(datastore, writer, expression, encoderContext);
            }
            if (list.size() > 1) {
                writer.writeEndArray();
            }
        } else {
            writer.writeNull();
        }
    }

    @Override
    public ExpressionList getValue() {
        return (ExpressionList)super.getValue();
    }
}

