/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class AccumulatorExpression
extends Expression {
    private final String initFunction;
    private final String accumulateFunction;
    private final List<Expression> accumulateArgs;
    private final String mergeFunction;
    private final String lang = "js";
    private List<Expression> initArgs;
    private String finalizeFunction;

    @MorphiaInternal
    public AccumulatorExpression(String initFunction, String accumulateFunction, List<Expression> accumulateArgs, String mergeFunction) {
        super("$accumulator");
        this.initFunction = initFunction;
        this.accumulateFunction = accumulateFunction;
        this.accumulateArgs = accumulateArgs;
        this.mergeFunction = mergeFunction;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, this.getOperation(), () -> {
            writer.writeString("init", this.initFunction);
            ExpressionHelper.array(datastore, writer, "initArgs", this.initArgs, encoderContext);
            writer.writeString("accumulate", this.accumulateFunction);
            ExpressionHelper.array(datastore, writer, "accumulateArgs", this.accumulateArgs, encoderContext);
            writer.writeString("merge", this.mergeFunction);
            writer.writeString("finalize", this.finalizeFunction);
            writer.writeString("lang", "js");
        });
    }

    public AccumulatorExpression finalizeFunction(String finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public AccumulatorExpression initArgs(List<Expression> initArgs) {
        this.initArgs = initArgs;
        return this;
    }
}

