/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.annotations.internal.MorphiaInternal;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class ArrayIndexExpression
extends Expression {
    private final Expression array;
    private final Expression search;
    private Integer start;
    private Integer end;

    @MorphiaInternal
    public ArrayIndexExpression(Expression array, Expression search) {
        super("$indexOfArray");
        this.array = array;
        this.search = search;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.array(writer, this.getOperation(), () -> {
            ExpressionHelper.expression(datastore, writer, this.array, encoderContext);
            ExpressionHelper.expression(datastore, writer, this.search, encoderContext);
            ExpressionHelper.value(datastore, writer, this.start, encoderContext);
            ExpressionHelper.value(datastore, writer, this.end, encoderContext);
        });
    }

    public ArrayIndexExpression end(Integer end) {
        this.end = end;
        return this;
    }

    public ArrayIndexExpression start(Integer start) {
        this.start = start;
        return this;
    }
}

