/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.ArrayExpression;
import dev.morphia.aggregation.expressions.impls.Expression;
import java.util.Arrays;
import java.util.Collections;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class ArrayLiteral
extends ArrayExpression {
    private Object[] objects;

    public ArrayLiteral(Expression ... values) {
        super("unused", Arrays.asList(values));
    }

    public ArrayLiteral(Object ... objects) {
        super("unused", Collections.emptyList());
        this.objects = objects;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        if (this.objects == null) {
            Expression value = this.getValue();
            if (value != null) {
                value.encode(datastore, writer, encoderContext);
            }
        } else {
            ExpressionHelper.array(writer, () -> {
                for (Object object : this.objects) {
                    ExpressionHelper.value(datastore, writer, object, encoderContext);
                }
            });
        }
    }
}

