/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.impls.ConvertType;
import dev.morphia.aggregation.expressions.impls.Expression;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class ConvertExpression
extends Expression {
    private final Expression input;
    private final ConvertType to;
    private Expression onError;
    private Expression onNull;

    public ConvertExpression(Expression input, ConvertType to) {
        super("$convert");
        this.input = input;
        this.to = to;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, this.getOperation(), () -> {
            ExpressionHelper.expression(datastore, writer, "input", this.input, encoderContext);
            ExpressionHelper.value(writer, "to", this.to.getName());
            ExpressionHelper.expression(datastore, writer, "onError", this.onError, encoderContext);
            ExpressionHelper.expression(datastore, writer, "onNull", this.onNull, encoderContext);
        });
    }

    public ConvertExpression onError(Expression onError) {
        this.onError = onError;
        return this;
    }

    public ConvertExpression onNull(Expression onNull) {
        this.onNull = onNull;
        return this;
    }
}

