/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.TimeUnit;
import dev.morphia.aggregation.expressions.impls.Expression;
import dev.morphia.annotations.internal.MorphiaInternal;
import java.util.Locale;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class DateDeltaExpression
extends Expression {
    private final Expression startDate;
    private final long amount;
    private final TimeUnit unit;
    private Expression timezone;

    @MorphiaInternal
    public DateDeltaExpression(String operator, Expression startDate, long amount, TimeUnit unit) {
        super(operator);
        this.startDate = startDate;
        this.amount = amount;
        this.unit = unit;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, this.getOperation(), () -> {
            ExpressionHelper.expression(datastore, writer, "startDate", this.startDate, encoderContext);
            writer.writeString("unit", this.unit.name().toLowerCase(Locale.ROOT));
            writer.writeInt64("amount", this.amount);
            ExpressionHelper.expression(datastore, writer, "timezone", this.timezone, encoderContext);
        });
    }

    public DateDeltaExpression timezone(Expression timezone) {
        this.timezone = timezone;
        return this;
    }
}

