/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.expressions.impls;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.expressions.TimeUnit;
import dev.morphia.aggregation.expressions.impls.Expression;
import java.time.DayOfWeek;
import java.util.Locale;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class DateDiffExpression
extends Expression {
    private final Expression startDate;
    private final Expression endDate;
    private final TimeUnit unit;
    private Expression timezone;
    private DayOfWeek startOfWeek;

    public DateDiffExpression(Expression startDate, Expression endDate, TimeUnit unit) {
        super("$dateDiff");
        this.startDate = startDate;
        this.endDate = endDate;
        this.unit = unit;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, this.getOperation(), () -> {
            ExpressionHelper.expression(datastore, writer, "startDate", this.startDate, encoderContext);
            ExpressionHelper.expression(datastore, writer, "endDate", this.endDate, encoderContext);
            writer.writeString("unit", this.unit.name().toLowerCase(Locale.ROOT));
            ExpressionHelper.expression(datastore, writer, "timezone", this.timezone, encoderContext);
            if (this.startOfWeek != null) {
                writer.writeString("startOfWeek", this.startOfWeek.name().toLowerCase(Locale.ROOT));
            }
        });
    }

    public DateDiffExpression startOfWeek(DayOfWeek startOfWeek) {
        this.startOfWeek = startOfWeek;
        return this;
    }

    public DateDiffExpression timezone(Expression timezone) {
        this.timezone = timezone;
        return this;
    }
}

